/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.util;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.util.Progress;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
@JsonSurrogate(value=Progress.class)
public class RestProgress
extends RestMapEntity {
    public static final String MESSAGE = "message";
    public static final String PERCENTAGE = "percentage";

    public RestProgress(@Nonnull Progress progress) {
        this.putIfNotNull(MESSAGE, StringUtils.trimToNull((String)progress.getMessage()));
        this.put(PERCENTAGE, progress.getPercentage());
    }

    @Schema(example="Working on it...")
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @Schema(example="42")
    public Integer getPercentage() {
        return this.getIntProperty(PERCENTAGE);
    }
}

