/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=PermittedGroup.class)
public class RestPermittedGroup
extends RestMapEntity {
    public static final Function<PermittedGroup, RestPermittedGroup> REST_TRANSFORM = RestPermittedGroup::fromPermittedGroup;
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String PERMISSION = "permission";

    public RestPermittedGroup(PermittedGroup permittedGroup) {
        this(permittedGroup.getGroup(), permittedGroup.getPermission());
    }

    private RestPermittedGroup(String name, Permission permission) {
        this.put(GROUP, ImmutableMap.of((Object)NAME, (Object)name));
        this.put(PERMISSION, permission.name());
    }

    public static RestPermittedGroup fromPermittedGroup(PermittedGroup permittedGroup) {
        return permittedGroup != null ? new RestPermittedGroup(permittedGroup) : null;
    }

    @Schema(implementation=Group.class)
    public Map<String, String> getGroup() {
        return (Map)this.get(GROUP);
    }

    @Schema(example="ADMIN")
    public String getPermission() {
        return this.getStringProperty(PERMISSION);
    }

    private static interface Group {
        @Schema(example="group_a")
        public String getName();
    }
}

