/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull;

import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Set;

@JsonSerialize
@JsonSurrogate(value=PullRequestReviewersUpdatedActivity.class)
public class RestPullRequestReviewersUpdatedActivity
extends RestPullRequestActivity {
    private static final String ADDED_REVIEWERS = "addedReviewers";
    private static final String REMOVED_REVIEWERS = "removedReviewers";

    public RestPullRequestReviewersUpdatedActivity(PullRequestReviewersUpdatedActivity activity) {
        this(activity.getId(), activity.getCreatedDate(), new RestApplicationUser(activity.getUser()), activity.getAction(), RestPullRequestReviewersUpdatedActivity.restReviewers(activity.getAddedReviewers()), RestPullRequestReviewersUpdatedActivity.restReviewers(activity.getRemovedReviewers()));
    }

    private RestPullRequestReviewersUpdatedActivity(long id, Date createdDate, RestApplicationUser restStashUser, PullRequestAction action, Set<RestApplicationUser> addedReviewers, Set<RestApplicationUser> removedReviewers) {
        super(id, createdDate, restStashUser, action);
        this.put(ADDED_REVIEWERS, addedReviewers);
        this.put(REMOVED_REVIEWERS, removedReviewers);
    }

    @ArraySchema(schema=@Schema(implementation=RestApplicationUser.class))
    public Set<RestApplicationUser> getAddedReviewers() {
        return (Set)this.get(ADDED_REVIEWERS);
    }

    @ArraySchema(schema=@Schema(implementation=RestApplicationUser.class))
    public Set<RestApplicationUser> getRemovedReviewers() {
        return (Set)this.get(REMOVED_REVIEWERS);
    }

    private static Set<RestApplicationUser> restReviewers(Set<ApplicationUser> reviewers) {
        return (Set)reviewers.stream().map(RestApplicationUser.REST_TRANSFORM).collect(MoreCollectors.toImmutableSet());
    }
}

