/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=InvalidPullRequestReviewersException.class)
public class RestInvalidPullRequestReviewersErrorMessage
extends RestErrorMessage {
    public static final String REVIEWER_ERRORS = "reviewerErrors";
    public static final String VALID_REVIEWERS = "validReviewers";

    public RestInvalidPullRequestReviewersErrorMessage(InvalidPullRequestReviewersException exception) {
        super("reviewers", exception.getLocalizedMessage(), exception.getClass().getCanonicalName());
        this.put(REVIEWER_ERRORS, ImmutableList.copyOf((Collection)Collections2.transform(exception.getReviewerErrors().entrySet(), entry -> new RestErrorMessage((String)entry.getKey(), ((KeyedMessage)entry.getValue()).getLocalisedMessage()))));
        this.put(VALID_REVIEWERS, ImmutableList.copyOf((Collection)Collections2.transform((Collection)exception.getValidReviewers(), user -> {
            ImmutableMap participantMap = ImmutableMap.of((Object)"user", (Object)new RestApplicationUser(user));
            return new RestPullRequestParticipant((Map)participantMap);
        })));
    }

    public Collection<RestErrorMessage> getReviewerErrors() {
        return (Collection)this.get(REVIEWER_ERRORS);
    }

    public Collection<RestPullRequestParticipant> getValidReviewers() {
        return (Collection)this.get(VALID_REVIEWERS);
    }
}

