/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.migration;

import com.atlassian.bitbucket.dmz.rest.v2.validation.RepositorySelectorValid;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@RepositorySelectorValid
public class RestRepositorySelector
extends RestMapEntity {
    public static final String PROJECT_KEY = "projectKey";
    public static final String SLUG = "slug";

    public RestRepositorySelector() {
    }

    public RestRepositorySelector(String projectKey, String slug) {
        this.put(PROJECT_KEY, projectKey);
        this.put(SLUG, slug);
    }

    public RestRepositorySelector(Map value) {
        super(value);
    }

    @RequiredString(message="{bitbucket.rest.migration.projectkey.required}")
    @Schema(example="PRJ")
    @Nonnull
    public String getProjectKey() {
        return this.getStringProperty(PROJECT_KEY);
    }

    @RequiredString(message="{bitbucket.rest.migration.repositoryslug.required}")
    @Schema(example="my-repo")
    @Nonnull
    public String getSlug() {
        return this.getStringProperty(SLUG);
    }

    @Nullable
    public static RestRepositorySelector valueOf(@Nullable Object value) {
        if (value instanceof RestRepositorySelector) {
            return (RestRepositorySelector)((Object)value);
        }
        if (value instanceof Map) {
            return new RestRepositorySelector((Map)value);
        }
        return null;
    }
}

