/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.validator.constraints.URL;

@JsonSerialize
@JsonSurrogate(value=MeshNode.class)
public class RestMeshNode
extends RestMapEntity {
    public RestMeshNode() {
    }

    public RestMeshNode(MeshNode node) {
        this.put("id", node.getId());
        this.put("availabilityZone", node.getAvailabilityZone());
        this.putIfNotNull("lastSeenDate", node.getLastSeenDate());
        this.put("name", node.getName());
        this.put("rpcId", node.getRpcId());
        this.put("rpcUrl", node.getRpcUrl());
        this.put("state", node.getState());
        this.put("offline", node.isOffline());
    }

    public RestMeshNode(Map<String, ?> sourceNode) {
        super(sourceNode);
    }

    @Nullable
    @Schema(example="zone-1")
    @OptionalString
    public String getAvailabilityZone() {
        return this.getStringProperty("availabilityZone");
    }

    @Nonnull
    @Schema(example="1")
    public String getId() {
        return this.getStringProperty("id");
    }

    @Nullable
    @Schema(example="1630041546433", type="number")
    public Date getLastSeenDate() {
        return (Date)this.get("lastSeenDate");
    }

    @Nullable
    @Schema(example="My node")
    @OptionalString
    public String getName() {
        return this.getStringProperty("name");
    }

    @Nonnull
    @Schema(example="1")
    public String getRpcId() {
        return this.getStringProperty("rpcId");
    }

    @Nonnull
    @Schema(example="http://127.0.0.1:7999")
    @URL
    @RequiredString(groups={Create.class})
    public String getRpcUrl() {
        return this.getStringProperty("rpcUrl");
    }

    @Nullable
    @Schema(example="AVAILABLE")
    public MeshNode.State getState() {
        return (MeshNode.State)this.getEnumProperty("state", MeshNode.State.class);
    }

    @Schema(example="FALSE")
    public boolean isOffline() {
        return this.getBoolProperty("offline");
    }

    public static RestMeshNode valueOf(Object value) {
        if (value instanceof RestMeshNode) {
            return (RestMeshNode)((Object)value);
        }
        if (value instanceof Map) {
            Map values = (Map)value;
            return new RestMeshNode(values);
        }
        return null;
    }
}

