/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.build;

import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=BuildSummary.class)
public class RestBuildSummary
extends RestMapEntity {
    private static final String CANCELLED = "cancelled";
    private static final String FAILED = "failed";
    private static final String IN_PROGRESS = "inProgress";
    private static final String SUCCESSFUL = "successful";
    private static final String UNKNOWN = "unknown";

    public RestBuildSummary(BuildSummary stats) {
        this(stats.getCancelledCount(), stats.getSuccessfulCount(), stats.getInProgressCount(), stats.getFailedCount(), stats.getUnknownCount());
    }

    public RestBuildSummary(Map<String, ?> values) {
        super(values);
    }

    protected RestBuildSummary(int cancelled, int successful, int inProgress, int failed, int unknown) {
        this.put(CANCELLED, cancelled);
        this.put(SUCCESSFUL, successful);
        this.put(IN_PROGRESS, inProgress);
        this.put(FAILED, failed);
        this.put(UNKNOWN, unknown);
    }

    @Schema(example="4")
    public int getFailed() {
        return this.getIntProperty(FAILED);
    }

    @Schema(example="1")
    public int getInProgress() {
        return this.getIntProperty(IN_PROGRESS);
    }

    @Schema(example="12")
    public int getSuccessful() {
        return this.getIntProperty(SUCCESSFUL);
    }
}

