/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.content;

import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.ConflictChange;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=ConflictChange.class)
public class RestConflictChange
extends RestMapEntity {
    private static final String PATH = "path";
    private static final String SRC_PATH = "srcPath";
    private static final String TYPE = "type";

    public RestConflictChange(ConflictChange change) {
        this.put(TYPE, change.getType());
        this.put(PATH, new RestPath(change.getPath()));
        Path srcPath = change.getSrcPath();
        if (srcPath != null) {
            this.put(SRC_PATH, new RestPath(srcPath));
        }
    }

    public RestPath getPath() {
        return (RestPath)this.get(PATH);
    }

    public RestPath getSrcPath() {
        return (RestPath)this.get(SRC_PATH);
    }

    public ChangeType getType() {
        return this.getEnumProperty(TYPE, ChangeType.class);
    }
}

