/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.comment;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.validation.constraints.Positive;

@JsonSerialize
public class RestMultilineCommentSpan
extends RestMapEntity {
    public static final String DESTINATION_SPAN_END = "dstSpanEnd";
    public static final String DESTINATION_SPAN_START = "dstSpanStart";
    public static final String SOURCE_SPAN_END = "srcSpanEnd";
    public static final String SOURCE_SPAN_START = "srcSpanStart";

    public RestMultilineCommentSpan(Map<String, Integer> values) {
        this.putAll(values);
    }

    public RestMultilineCommentSpan(int sourceSpanStart, int sourceSpanEnd, int destinationSpanStart, int destinationSpanEnd) {
        this.put(SOURCE_SPAN_START, sourceSpanStart);
        this.put(SOURCE_SPAN_END, sourceSpanEnd);
        this.put(DESTINATION_SPAN_START, destinationSpanStart);
        this.put(DESTINATION_SPAN_END, destinationSpanEnd);
    }

    public RestMultilineCommentSpan(@Nonnull CommentThreadDiffAnchor diffAnchor) {
        diffAnchor.getMultilineSourceRange().ifPresent(sourceRange -> {
            this.put(SOURCE_SPAN_START, sourceRange.minimum());
            this.put(SOURCE_SPAN_END, sourceRange.maximum());
        });
        diffAnchor.getMultilineDestinationRange().ifPresent(destinationRange -> {
            this.put(DESTINATION_SPAN_START, destinationRange.minimum());
            this.put(DESTINATION_SPAN_END, destinationRange.maximum());
        });
    }

    @Nonnull
    @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}")
    @Schema(description="The line number of the last line on the right-hand side of the diff that the comment spans", implementation=Integer.class, accessMode=Schema.AccessMode.READ_ONLY, example="3")
    public @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}") OptionalInt getDstSpanEnd() {
        return this.getIntValue(DESTINATION_SPAN_END);
    }

    @Nonnull
    @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}")
    @Schema(description="The line number of the first line on the right-hand side of the diff that the comment spans", implementation=Integer.class, accessMode=Schema.AccessMode.READ_ONLY, example="2")
    public @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}") OptionalInt getDstSpanStart() {
        return this.getIntValue(DESTINATION_SPAN_START);
    }

    @Nonnull
    @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}")
    @Schema(description="The line number of the last line on the left-hand side of the diff that the comment spans", implementation=Integer.class, accessMode=Schema.AccessMode.READ_ONLY, example="2")
    public @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}") OptionalInt getSrcSpanEnd() {
        return this.getIntValue(SOURCE_SPAN_END);
    }

    @Nonnull
    @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}")
    @Schema(description="The line number of the first line on the left-hand side of the diff that the comment spans", implementation=Integer.class, accessMode=Schema.AccessMode.READ_ONLY, example="1")
    public @Positive(message="{bitbucket.rest.comment.anchor.multiline.negativespan}") OptionalInt getSrcSpanStart() {
        return this.getIntValue(SOURCE_SPAN_START);
    }

    private OptionalInt getIntValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return OptionalInt.empty();
        }
        if (value instanceof Number) {
            return OptionalInt.of(((Number)value).intValue());
        }
        return OptionalInt.of(-1);
    }
}

