/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.content;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.comment.RestMultilineCommentMarker;
import com.atlassian.bitbucket.rest.v2.api.comment.RestMultilineCommentSpan;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonSerialize
@JsonSurrogate(value=CommentThreadDiffAnchor.class)
public class RestCommentThreadDiffAnchor
extends RestMapEntity {
    public static final Function<CommentThreadDiffAnchor, RestCommentThreadDiffAnchor> REST_TRANSFORM = RestCommentThreadDiffAnchor::new;
    private static final String DIFF_TYPE = "diffType";
    private static final String FILE_TYPE = "fileType";
    private static final String FROM_HASH = "fromHash";
    private static final String LINE = "line";
    private static final String LINE_TYPE = "lineType";
    private static final String MULTILINE_MARKER = "multilineMarker";
    private static final String MULTILINE_SPAN = "multilineSpan";
    private static final String ORPHANED = "orphaned";
    private static final String PATH = "path";
    private static final String PULL_REQUEST = "pullRequest";
    private static final String SRC_PATH = "srcPath";
    private static final String TO_HASH = "toHash";

    public RestCommentThreadDiffAnchor() {
    }

    public RestCommentThreadDiffAnchor(Map<String, Object> values) {
        super(values);
    }

    public RestCommentThreadDiffAnchor(CommentThreadDiffAnchor anchor) {
        this(anchor.getFromHash().orElse(null), anchor.getToHash(), anchor.getPath(), anchor.getSrcPath().orElse(null), anchor.isLineAnchor() ? Integer.valueOf(anchor.getLine()) : null, anchor.getLineType().orElse(null), anchor.getFileType().orElse(null));
        if (anchor.isMultilineAnchor()) {
            this.put(MULTILINE_MARKER, new RestMultilineCommentMarker((int)((Integer)anchor.getMultilineStartLine().get()), (DiffSegmentType)anchor.getMultilineStartLineType().get()));
            this.put(MULTILINE_SPAN, new RestMultilineCommentSpan(anchor));
        }
        this.put(DIFF_TYPE, anchor.getDiffType());
        this.put(ORPHANED, anchor.isOrphaned());
    }

    private RestCommentThreadDiffAnchor(String fromHash, String toHash, String path, String srcPath, Integer line, DiffSegmentType lineType, DiffFileType fileType) {
        this(fromHash, toHash, line, lineType, fileType);
        this.putIfNotNull(PATH, path);
        this.putIfNotNull(SRC_PATH, srcPath);
    }

    private RestCommentThreadDiffAnchor(String fromHash, String toHash, Integer line, DiffSegmentType lineType, DiffFileType fileType) {
        this.putIfNotNull(FROM_HASH, fromHash);
        this.putIfNotNull(TO_HASH, toHash);
        this.putIfNotNull(LINE, line);
        this.putIfNotNull(LINE_TYPE, lineType);
        this.putIfNotNull(FILE_TYPE, fileType);
    }

    private RestCommentThreadDiffAnchor(String fromHash, String toHash, Integer line, DiffSegmentType lineType, DiffFileType fileType, RestPullRequest pullRequest) {
        this.putIfNotNull(FROM_HASH, fromHash);
        this.putIfNotNull(TO_HASH, toHash);
        this.putIfNotNull(LINE, line);
        this.putIfNotNull(LINE_TYPE, lineType);
        this.putIfNotNull(FILE_TYPE, fileType);
        this.putIfNotNull(PULL_REQUEST, pullRequest);
    }

    public CommentThreadDiffAnchorType getDiffType() {
        return this.getEnumProperty(DIFF_TYPE, CommentThreadDiffAnchorType.class);
    }

    public DiffFileType getFileType() {
        return this.getEnumProperty(FILE_TYPE, DiffFileType.class);
    }

    @Schema(example="62a0505e8204115b8b9c8a95bfa264a8c0896a93")
    public String getFromHash() {
        return this.getStringProperty(FROM_HASH);
    }

    @Schema(example="98")
    public int getLine() {
        return this.getIntProperty(LINE);
    }

    public DiffSegmentType getLineType() {
        return this.getEnumProperty(LINE_TYPE, DiffSegmentType.class);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public RestMultilineCommentMarker getMultilineMarker() {
        Object marker = this.get(MULTILINE_MARKER);
        if (marker instanceof RestMultilineCommentMarker) {
            return (RestMultilineCommentMarker)marker;
        }
        if (marker instanceof Map) {
            return new RestMultilineCommentMarker((Map)marker);
        }
        return null;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public RestMultilineCommentSpan getMultilineSpan() {
        Object span = this.get(MULTILINE_SPAN);
        if (span instanceof RestMultilineCommentSpan) {
            return (RestMultilineCommentSpan)span;
        }
        if (span instanceof Map) {
            return new RestMultilineCommentSpan((Map)span);
        }
        return null;
    }

    public RestPath getPath() {
        return this.getPathProperty(PATH);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public RestPullRequest getPullRequest() {
        return RestPullRequest.valueOf(this.get(PULL_REQUEST));
    }

    public RestPath getSrcPath() {
        return this.getPathProperty(SRC_PATH);
    }

    @Schema(example="3cdd5d19178a54d2e51b5098d43b57571241d0ab")
    public String getToHash() {
        return this.getStringProperty(TO_HASH);
    }

    public boolean hasSrcPath() {
        return this.containsKey(SRC_PATH);
    }

    @Hidden
    public boolean isLineComment() {
        return this.containsKey(LINE) && this.containsKey(LINE_TYPE);
    }

    @Hidden
    public boolean isMultilineComment() {
        return this.containsKey(MULTILINE_MARKER);
    }
}

