/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.commit;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.v2.api.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.commit.RestMinimalCommit;
import com.atlassian.bitbucket.rest.v2.api.content.RestChange;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.util.RestNamedLink;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.rest.v2.api.util.RestRelatedLinks;
import com.atlassian.bitbucket.util.Page;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Changeset.class)
public class RestChangeset
extends RestLinkedMapEntity {
    private static final String CHANGES = "changes";
    private static final String FROM_COMMIT = "fromCommit";
    private static final String REPOSITORY = "repository";
    private static final String TO_COMMIT = "toCommit";

    public RestChangeset(Changeset changeset, NavBuilder navBuilder) {
        this(changeset, navBuilder, true);
    }

    public RestChangeset(Changeset changeset, NavBuilder navBuilder, boolean includeRepository) {
        this(changeset, navBuilder.repo(changeset.getToCommit().getRepository()).commit(changeset.getToCommit().getId()), includeRepository);
    }

    private RestChangeset(Changeset changeset, NavBuilder.Commit commitNav, boolean includeRepository) {
        this(RestMinimalCommit.REST_TRANSFORM.apply(changeset.getFromCommit()), new RestCommit(changeset.getToCommit()), RestChangeset.transform((Page<? extends Change>)changeset.getChanges(), commitNav), includeRepository ? new RestRepository(changeset.getToCommit().getRepository(), true) : null, new RestNamedLink(commitNav.buildAbsolute()));
    }

    private RestChangeset(RestMinimalCommit fromCommit, RestCommit toCommit, RestPage<RestChange> changes, RestRepository repository, RestNamedLink selfLink) {
        this.put(FROM_COMMIT, fromCommit);
        this.put(TO_COMMIT, toCommit);
        this.put(CHANGES, changes);
        this.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", selfLink).build());
        this.putIfNotNull(REPOSITORY, repository);
    }

    public RestPage<RestChange> getChanges() {
        return (RestPage)this.get(CHANGES);
    }

    public RestMinimalCommit getFromCommit() {
        return (RestMinimalCommit)this.get(FROM_COMMIT);
    }

    public RestRepository getRepository() {
        return (RestRepository)this.get(REPOSITORY);
    }

    public RestCommit getToCommit() {
        return (RestCommit)this.get(TO_COMMIT);
    }

    private static RestPage<RestChange> transform(Page<? extends Change> changes, NavBuilder.Commit changesetNav) {
        return changes == null ? null : new RestPage<RestChange>(changes, RestChange.transform(changesetNav));
    }
}

