/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.content;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffLine;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=DiffLine.class)
public class RestDiffLine
extends RestMapEntity {
    public static final Function<DiffLine, RestDiffLine> REST_TRANSFORM = RestDiffLine::new;
    private static final String COMMENT_IDS = "commentIds";
    private static final String CONFLICTED_MARKER = "conflictedMarker";
    private static final String DESTINATION = "destination";
    private static final String LINE = "line";
    private static final String SOURCE = "source";
    private static final String TRUNCATED = "truncated";

    public RestDiffLine() {
    }

    public RestDiffLine(DiffLine line) {
        this(line.getSource(), line.getDestination(), line.getLine(), line.isConflicting(), line.getConflictMarker(), line.getCommentIds(), line.isTruncated());
    }

    private RestDiffLine(int source, int destination, String line, boolean conflicted, ConflictMarker conflictMarker, List<Long> commentIds, boolean truncated) {
        this.putIfNotNull(DESTINATION, destination);
        this.putIfNotNull(SOURCE, source);
        this.putIfNotNull(LINE, line);
        this.putIfNotNull(TRUNCATED, truncated);
        if (conflicted) {
            this.put(CONFLICTED_MARKER, conflictMarker);
        }
        this.putIfNotEmpty(COMMENT_IDS, (Collection<?>)commentIds);
    }

    @ArraySchema(schema=@Schema(implementation=Long.class))
    public List<Long> getCommentIds() {
        return (List)this.get(COMMENT_IDS);
    }

    public ConflictMarker getConflictMarker() {
        return this.getEnumProperty(CONFLICTED_MARKER, ConflictMarker.class);
    }

    public int getDestination() {
        return this.getIntProperty(DESTINATION);
    }

    public String getLine() {
        return this.getStringProperty(LINE);
    }

    public int getSource() {
        return this.getIntProperty(SOURCE);
    }

    public boolean isTruncated() {
        return this.getBoolProperty(TRUNCATED);
    }
}

