/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.PathParam;

public class UserResolver {
    private final I18nService i18nService;
    private final UserService userService;
    private final String userSlug;
    private ApplicationUser user;

    public UserResolver(I18nService i18nService, PermissionValidationService permissionValidationService, UserService userService, @PathParam(value="userSlug") String userSlug) {
        permissionValidationService.validateAuthenticated();
        this.i18nService = i18nService;
        this.userService = userService;
        this.userSlug = userSlug;
    }

    @Nonnull
    public ApplicationUser getUser() {
        if (this.user == null) {
            this.user = this.userService.getSystemServiceUser();
            if (this.user.getSlug().equalsIgnoreCase(this.userSlug)) {
                return this.user;
            }
            this.user = this.userService.getUserBySlug(this.userSlug);
            if (this.user == null) {
                throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchuser", new Object[]{this.userSlug}), this.userSlug);
            }
        }
        return this.user;
    }

    @Nullable
    public String getUserSlug() {
        return this.userSlug;
    }
}

