/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.v2.api.resolver;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class NumberParser {
    public static int parseInt(@Nonnull I18nService i18nService, @Nonnull String property, @Nonnull String value) {
        Objects.requireNonNull(i18nService, "i18nService");
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(value, "value");
        try {
            int valueAsInteger = Integer.parseInt(value);
            if (valueAsInteger < 0) {
                throw new NumberFormatException();
            }
            return valueAsInteger;
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(property, i18nService.createKeyedMessage("bitbucket.rest.invalidargument.wholenumberinteger", new Object[]{value, property}).getLocalisedMessage());
        }
    }

    public static long parseLong(@Nonnull I18nService i18nService, @Nonnull String property, @Nonnull String value) {
        Objects.requireNonNull(i18nService, "i18nService");
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(value, "value");
        try {
            long valueAsLong = Long.parseLong(value);
            if (valueAsLong < 0L) {
                throw new NumberFormatException();
            }
            return valueAsLong;
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(property, i18nService.createKeyedMessage("bitbucket.rest.invalidargument.wholenumberlong", new Object[]{value, property}).getLocalisedMessage());
        }
    }
}

