/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull.reviewer;

import com.atlassian.bitbucket.dmz.rest.v2.pull.reviewer.RestReviewerGroup;
import com.atlassian.bitbucket.internal.rest.user.RestUserSearchRequestParser;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupService;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageImpl;
import com.atlassian.bitbucket.util.PageRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public class ReviewerSearchService {
    private final RestUserSearchRequestParser restUserSearchRequestParser;
    private final ReviewerGroupService reviewerGroupService;
    private final UserService userService;

    public ReviewerSearchService(RestUserSearchRequestParser restUserSearchRequestParser, ReviewerGroupService reviewerGroupService, UserService userService) {
        this.reviewerGroupService = reviewerGroupService;
        this.restUserSearchRequestParser = restUserSearchRequestParser;
        this.userService = userService;
    }

    public Page<Object> searchReviewerGroupsAndUsers(UriInfo uriInfo, Scope scope, PageRequest pageRequest) {
        Objects.requireNonNull(uriInfo, "uriInfo");
        UserSearchRequest searchRequest = this.restUserSearchRequestParser.parse((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        Page usersPage = this.userService.search(searchRequest, pageRequest);
        List<RestApplicationUser> restUsers = usersPage.stream().map(RestApplicationUser::new).collect(Collectors.toList());
        Page reviewerGroupsPage = searchRequest.getFilter() == null ? this.reviewerGroupService.findByScope(scope, pageRequest) : this.reviewerGroupService.findByName(scope, searchRequest.getFilter(), pageRequest);
        List<RestReviewerGroup> restReviewerGroups = reviewerGroupsPage.stream().map(RestReviewerGroup::new).collect(Collectors.toList());
        List<Object> results = ReviewerSearchService.mergeSortGroupsWithUsers(restReviewerGroups, restUsers);
        return new PageImpl(pageRequest, results, reviewerGroupsPage.getIsLastPage() && usersPage.getIsLastPage(), results.size(), pageRequest.getStart() + pageRequest.getLimit());
    }

    private static List<Object> mergeSortGroupsWithUsers(List<RestReviewerGroup> restReviewerGroups, List<RestApplicationUser> restUsers) {
        ArrayList<Object> results = new ArrayList<Object>(restReviewerGroups.size() + restReviewerGroups.size());
        results.addAll(restReviewerGroups);
        results.addAll(restUsers);
        results.sort(Comparator.comparing(ReviewerSearchService::getKey));
        return results;
    }

    private static String getKey(Object value) {
        if (value instanceof RestReviewerGroup) {
            return ((RestReviewerGroup)value).getName();
        }
        return ((RestApplicationUser)value).getName();
    }
}

