/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.discovery;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.discovery.DiscoverableFeature;
import com.atlassian.bitbucket.dmz.discovery.FeatureDiscoveryService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="/feature-discovery")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class FeatureDiscoveryResource {
    private final AuthenticationContext authenticationContext;
    private final FeatureDiscoveryService featureDiscoveryService;

    @Inject
    public FeatureDiscoveryResource(AuthenticationContext authenticationContext, FeatureDiscoveryService featureDiscoveryService) {
        this.authenticationContext = authenticationContext;
        this.featureDiscoveryService = featureDiscoveryService;
    }

    @GET
    @Path(value="/features/undiscovered")
    public Response getAllUndiscoveredFeatures() {
        Set features = this.featureDiscoveryService.getUndiscovered();
        return ResponseFactory.ok().entity(Collections.singletonMap("undiscovered", features)).build();
    }

    @GET
    @Path(value="/features/{featureName}")
    public Response getFeatureDiscoveredState(@PathParam(value="featureName") String featureName) {
        if (!this.authenticationContext.isAuthenticated()) {
            return ResponseFactory.error((Response.Status)Response.Status.UNAUTHORIZED, (String)"featureName", (String)"You are not permitted to access this resource").build();
        }
        return DiscoverableFeature.fromName((String)featureName).map(discoverableFeature -> {
            Set undiscovered = this.featureDiscoveryService.getIfUndiscovered(EnumSet.of(discoverableFeature));
            return ResponseFactory.ok().entity(Collections.singletonMap("discovered", undiscovered.isEmpty())).build();
        }).orElseGet(() -> ResponseFactory.error((Response.Status)Response.Status.NOT_FOUND, (String)"featureName", (String)("No feature called '" + featureName + "' exists.")).build());
    }

    @PUT
    @Path(value="/features/{featureName}/discovered")
    public Response setFeatureDiscoveredState(@PathParam(value="featureName") String featureName) {
        if (!this.authenticationContext.isAuthenticated()) {
            return ResponseFactory.error((Response.Status)Response.Status.UNAUTHORIZED, (String)"featureName", (String)"You are not permitted to access this resource").build();
        }
        return DiscoverableFeature.fromName((String)featureName).map(discoverableFeature -> {
            this.featureDiscoveryService.setDiscovered(EnumSet.of(discoverableFeature));
            return ResponseFactory.noContent().build();
        }).orElseGet(() -> ResponseFactory.error((Response.Status)Response.Status.NOT_FOUND, (String)"featureName", (String)("No feature called '" + featureName + "' exists.")).build());
    }
}

