/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.dmz.rest.v2.cluster.RestClusterNode;
import com.atlassian.bitbucket.dmz.server.InvalidDataStoreException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=InvalidDataStoreException.class)
public class RestInvalidDataStoreErrors
extends RestMapEntity {
    public RestInvalidDataStoreErrors(InvalidDataStoreException exception) {
        ArrayList<RestErrorMessage> restErrors = new ArrayList<RestErrorMessage>();
        Map clusterErrors = exception.getClusterErrors();
        if (clusterErrors.isEmpty()) {
            restErrors.add(new RestErrorMessage((ServiceException)exception));
        } else {
            clusterErrors.entrySet().stream().map(entry -> new RestClusterErrorMessage((ClusterNode)entry.getKey(), (KeyedMessage)entry.getValue())).forEach(restErrors::add);
        }
        this.put("errors", restErrors);
    }

    @JsonSerialize
    private static class RestClusterErrorMessage
    extends RestErrorMessage {
        public RestClusterErrorMessage(ClusterNode node, KeyedMessage keyedMessage) {
            super(keyedMessage.getLocalisedMessage());
            this.put("node", new RestClusterNode(node));
        }
    }
}

