/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.bitbucket.dmz.user.DetailedUserSearchRequest;
import com.atlassian.bitbucket.dmz.user.DmzCsvExportService;
import com.atlassian.bitbucket.dmz.user.DmzUserAdminService;
import com.atlassian.bitbucket.dmz.user.LicenseStatus;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestDetailedUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.ContentDispositionUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/users")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class InternalUserAdminResource {
    private final DmzCsvExportService csvExportService;
    private final DmzUserAdminService userAdminService;

    @Inject
    public InternalUserAdminResource(DmzUserAdminService userAdminService, DmzCsvExportService csvExportService) {
        this.userAdminService = userAdminService;
        this.csvExportService = csvExportService;
    }

    @GET
    @Path(value="export")
    public Response exportUsers(@QueryParam(value="licenseStatus") String licenseStatus, @QueryParam(value="filterText") String filterText, @QueryParam(value="directoryName") String directoryName, @QueryParam(value="lastActiveBefore") String lastActiveBefore, @QueryParam(value="lastActiveAfter") String lastActiveAfter) {
        String date = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss'Z'").format(LocalDateTime.now(ZoneId.of("UTC")));
        String fileName = String.format("users-%s.csv", date);
        String contentDisposition = ContentDispositionUtils.buildHeaderValue((ContentDispositionUtils.DispositionType)ContentDispositionUtils.DispositionType.ATTACHMENT, (String)fileName, (Instant)Instant.now());
        DetailedUserSearchRequest.Builder request = new DetailedUserSearchRequest.Builder().filterText(filterText).directoryName(directoryName);
        this.enrichRequestWithQueryParams(request, licenseStatus, lastActiveBefore, lastActiveAfter);
        return Response.ok(output -> this.csvExportService.exportUsersToCsv(output, request.build())).type("text/csv").header("Content-Disposition", (Object)contentDisposition).build();
    }

    @GET
    public Response getUsers(@BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="licenseStatus") String licenseStatus, @QueryParam(value="filterText") String filterText, @QueryParam(value="directoryName") String directoryName, @QueryParam(value="lastActiveBefore") String lastActiveBefore, @QueryParam(value="lastActiveAfter") String lastActiveAfter) {
        DetailedUserSearchRequest.Builder request = new DetailedUserSearchRequest.Builder().filterText(filterText).directoryName(directoryName);
        this.enrichRequestWithQueryParams(request, licenseStatus, lastActiveBefore, lastActiveAfter);
        Page users = this.userAdminService.search(pageRequestResolver.getPageRequest(), request.build());
        return ResponseFactory.ok((Object)new RestPage(users, RestDetailedUser::new)).build();
    }

    private DetailedUserSearchRequest.Builder enrichRequestWithQueryParams(DetailedUserSearchRequest.Builder request, String licenseStatus, String lastActiveBefore, String lastActiveAfter) {
        if (licenseStatus != null) {
            try {
                request.licenseStatus(LicenseStatus.valueOf((String)licenseStatus));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(String.format("licenseStatus should be one of [%s, %s]", LicenseStatus.LICENSED, LicenseStatus.UNLICENSED));
            }
        }
        if (lastActiveBefore != null) {
            try {
                request.lastActiveBefore(Long.valueOf(Long.parseLong(lastActiveBefore)));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("lastActiveBefore should be a number");
            }
        }
        if (lastActiveAfter != null) {
            try {
                request.lastActiveAfter(Long.valueOf(Long.parseLong(lastActiveAfter)));
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("lastActiveAfter should be a number");
            }
        }
        return request;
    }
}

