/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.repository;

import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import com.atlassian.bitbucket.scope.ScopeType;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Repository.class)
public class RestRepository
extends RestLinkedMapEntity {
    public static final Function<Repository, RestRepository> REST_TRANSFORM = RestRepository::new;
    @Deprecated
    public static final RestRepository REQUEST_EXAMPLE_FOR_FORK = new RestRepository(0, "my-repo", null, null, null, null, null, null, null, null, RestProject.REQUEST_EXAMPLE_KEY_ONLY, "main", null, null, -1);
    @Deprecated
    public static final RestRepository REQUEST_EXAMPLE_FOR_UPDATE = new RestRepository(0, null, "My repo", null, null, null, null, null, false, null, RestProject.REQUEST_EXAMPLE_KEY_ONLY, "main", true, null, -1);
    @Deprecated
    public static final RestRepository REQUEST_EXAMPLE_NAME_ONLY = new RestRepository(0, null, "My repo", null, null, null, null, null, null, null, null, null, -1);
    @Deprecated
    public static final RestRepository REQUEST_EXAMPLE_WITH_PROJECT = new RestRepository(0, "my-repo", null, null, null, null, null, null, null, null, RestProject.REQUEST_EXAMPLE_KEY_ONLY, null, null, null, -1);
    @Deprecated
    public static final RestRepository REQUEST_EXAMPLE = new RestRepository(0, null, "My repo", null, null, "git", null, null, true, null, null, "main", null, null, -1);
    @Deprecated
    public static final RestRepository RESPONSE_EXAMPLE = new RestRepository(1, "my-repo", "My repo", "My repo description", "e3c939f9ef4a7fae272e", "git", Repository.State.AVAILABLE, "Available", true, null, RestProject.RESPONSE_EXAMPLE, null, true, new RestRelatedLinks.Builder().addRelatedLink("self", RestDocUtils.selfLink(Repository.class)).addRelatedLinks("clone", Arrays.asList(new RestNamedLink(RestRepository.httpCloneUrl("PRJ", "my-repo"), "http"), new RestNamedLink(RestRepository.sshCloneUrl("PRJ", "my-repo"), "ssh"))).build(), -1);
    @Deprecated
    public static final RestRepository RESPONSE_EXAMPLE_WITH_ORIGIN = new RestRepository(2, "my-repo", "My repo", "My repo description", "e3c939f9ef4a7fae272e", "git", Repository.State.AVAILABLE, "Available", true, RESPONSE_EXAMPLE, RestProject.RESPONSE_EXAMPLE_PERSONAL, null, null, new RestRelatedLinks.Builder().addRelatedLink("self", RestDocUtils.selfLink(Repository.class)).addRelatedLinks("clone", Arrays.asList(new RestNamedLink(RestRepository.httpCloneUrl("JDOE", "my-repo"), "http"), new RestNamedLink(RestRepository.sshCloneUrl("JDOE", "my-repo"), "ssh"))).build(), -1);
    @Deprecated
    public static final RestRepository REQUEST_EXAMPLE_WITH_PARTITION = new RestRepository(0, null, "My repo", null, null, "git", null, null, true, null, null, "main", null, null, 10);
    @Deprecated
    public static final RestRepository RESPONSE_EXAMPLE_SIMPLE = new RestRepository(1, "my-repo", "My repo", RestProject.RESPONSE_EXAMPLE_SIMPLE, true, true);
    @Deprecated
    public static final RestPage<RestRepository> PAGE_EXAMPLE = RestDocUtils.pageOf(RESPONSE_EXAMPLE);
    @Deprecated
    public static final RestPage<RestRepository> PAGE_EXAMPLE_FOR_FORKS = RestDocUtils.pageOf(RESPONSE_EXAMPLE_WITH_ORIGIN);
    private static final String DESCRIPTION = "description";
    private static final String DEFAULT_BRANCH = "defaultBranch";
    private static final String FORKABLE = "forkable";
    private static final String HIERARCHY_ID = "hierarchyId";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ORIGIN = "origin";
    private static final String PARTITION = "partition";
    private static final String PUBLIC = "public";
    private static final String PROJECT = "project";
    private static final String SCM_ID = "scmId";
    private static final String SLUG = "slug";
    private static final String STATE = "state";
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String SCOPE = "scope";

    public RestRepository() {
    }

    public RestRepository(Repository repository) {
        this(repository, true);
    }

    public RestRepository(Repository repository, boolean includeProject) {
        this(repository.getId(), repository.getSlug(), repository.getName(), repository.getDescription(), repository.getHierarchyId(), repository.getScmId(), repository.getState(), repository.getStatusMessage(), repository.isForkable(), repository.getOrigin() == null ? null : new RestRepository(repository.getOrigin(), includeProject), includeProject ? RestProject.fromProject(repository.getProject()) : null, repository.isPublic(), DmzRepository.getPartition((Repository)repository));
    }

    private RestRepository(int id, String slug, String name, String description, String hierarchyId, String scmId, Repository.State state, String statusMessage, Boolean forkable, RestRepository origin, RestProject project, Boolean publiclyAccessible, int partition) {
        this.putIfNotNull(SLUG, slug);
        if (id > 0) {
            this.put(ID, id);
        }
        this.put(NAME, name);
        this.putIfNotNull(DESCRIPTION, description);
        this.putIfNotNull(HIERARCHY_ID, hierarchyId);
        this.putIfNotNull(SCM_ID, scmId);
        this.putIfNotNull(STATE, state);
        this.putIfNotNull(STATUS_MESSAGE, statusMessage);
        this.putIfNotNull(FORKABLE, forkable);
        this.putIfNotNull(ORIGIN, (Object)origin);
        this.putIfNotNull(PROJECT, project);
        this.putIfNotNull(PUBLIC, publiclyAccessible);
        if (partition >= 0) {
            this.put(PARTITION, partition);
        }
    }

    private RestRepository(int id, String slug, String name, String description, String hierarchyId, String scmId, Repository.State state, String statusMessage, Boolean forkable, RestRepository origin, RestProject project, String defaultBranch, Boolean publiclyAccessible, RestRelatedLinks relatedLinks, int partition) {
        this(id, slug, name, description, hierarchyId, scmId, state, statusMessage, forkable, origin, project, publiclyAccessible, partition);
        this.putIfNotNull(DEFAULT_BRANCH, defaultBranch);
        if (relatedLinks != null) {
            this.setLinks(relatedLinks);
        }
    }

    private RestRepository(int id, String slug, String name, RestProject project, boolean forkable, boolean publiclyAccessible) {
        this(id, slug, name, null, null, null, null, null, forkable, null, null, publiclyAccessible, -1);
        this.put(PROJECT, project.getKey());
        this.put(SCOPE, ScopeType.REPOSITORY.name());
    }

    private RestRepository(Map<String, Object> values) {
        super(values);
    }

    public String getDefaultBranch() {
        return this.getStringProperty(DEFAULT_BRANCH);
    }

    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    public String getName() {
        return this.getStringProperty(NAME);
    }

    public int getId() {
        return this.getIntProperty(ID);
    }

    public RestRelatedLinks getRelatedLinks() {
        return (RestRelatedLinks)((Object)this.get("links"));
    }

    public RestProject getProject() {
        return RestProject.valueOf(this.get(PROJECT));
    }

    public String getScmId() {
        return this.getStringProperty(SCM_ID);
    }

    public String getSlug() {
        return this.getStringProperty(SLUG);
    }

    public boolean hasDefaultBranch() {
        return this.get(DEFAULT_BRANCH) != null;
    }

    public boolean hasDescription() {
        return this.containsKey(DESCRIPTION);
    }

    public boolean hasForkable() {
        return this.get(FORKABLE) != null;
    }

    public boolean hasProject() {
        return this.getProject() != null;
    }

    public boolean hasPublic() {
        return this.get(PUBLIC) != null;
    }

    public boolean isForkable() {
        return this.getBoolProperty(FORKABLE, true);
    }

    public boolean isPublic() {
        return this.getBoolProperty(PUBLIC, false);
    }

    public static RestRepository simple(Repository repository) {
        if (repository == null) {
            return null;
        }
        RestRepository restRepo = new RestRepository();
        restRepo.put(SCOPE, ScopeType.REPOSITORY.name());
        if (repository.getId() > 0) {
            restRepo.put(ID, repository.getId());
        }
        restRepo.put(NAME, repository.getName());
        restRepo.putIfNotNull(SLUG, repository.getSlug());
        restRepo.put(FORKABLE, repository.isForkable());
        if (repository.getOrigin() != null) {
            restRepo.put(ORIGIN, repository.getOrigin().getId());
        }
        restRepo.put(PROJECT, repository.getProject().getKey());
        restRepo.put(PUBLIC, repository.isPublic());
        if (DmzRepository.isRemote((Repository)repository)) {
            restRepo.put(PARTITION, DmzRepository.getPartition((Repository)repository));
        }
        return restRepo;
    }

    @Nullable
    public static RestRepository valueOf(@Nullable Object value) {
        if (value instanceof RestRepository) {
            return (RestRepository)((Object)value);
        }
        if (value instanceof Map) {
            return new RestRepository((Map)value);
        }
        return null;
    }

    private static String httpCloneUrl(String projKey, String repoSlug) {
        return "https://<baseURL>/scm/" + projKey + "/" + repoSlug + ".git";
    }

    private static String sshCloneUrl(String projKey, String repoSlug) {
        return "ssh://git@<baseURL>/" + projKey + "/" + repoSlug + ".git";
    }
}

