/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.project;

import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.avatar.AvatarAware;
import com.atlassian.bitbucket.rest.project.RestPersonalProject;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import com.atlassian.bitbucket.scope.ScopeType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Project.class)
public class RestProject
extends RestLinkedMapEntity
implements AvatarAware,
Project {
    public static final Function<Project, RestProject> REST_TRANSFORM = RestProject::fromProject;
    public static final ProjectVisitor<RestProject> TRANSFORM_VISITOR = new ProjectVisitor<RestProject>(){

        public RestProject visit(@Nonnull Project project) {
            return new RestProject(project);
        }

        public RestProject visit(@Nonnull PersonalProject project) {
            return new RestPersonalProject(project);
        }
    };
    @Deprecated
    public static final RestProject REQUEST_EXAMPLE_KEY_ONLY = new RestProject(0, null, "PRJ", null, null, null, null);
    @Deprecated
    public static final RestProject RESPONSE_EXAMPLE_PERSONAL = new RestProject(2, null, "~JDOE", "John Doe", null, ProjectType.PERSONAL, null, RestDocUtils.selfLink(Project.class));
    @Deprecated
    public static final RestProject RESPONSE_EXAMPLE = new RestProject(1, null, "PRJ", "My Cool Project", "The description for my cool project.", ProjectType.NORMAL, true, RestDocUtils.selfLink(Project.class));
    @Deprecated
    public static final RestProject RESPONSE_EXAMPLE_SIMPLE = new RestProject(1, "PRJ", "My Cool Project", ProjectType.NORMAL, true);
    @Deprecated
    public static final RestPage<RestProject> PAGE_EXAMPLE = RestDocUtils.pageOf(RESPONSE_EXAMPLE);
    private static final ImmutableMap<String, String> EXAMPLE_AVATAR_PARAM = ImmutableMap.of((Object)"avatar", (Object)"data:image/png;base64,<base64-encoded-image-data>");
    @Deprecated
    public static final RestProject REQUEST_EXAMPLE = RestDocUtils.decorate(new RestProject(0, null, "PRJ", "My Cool Project", "The description for my cool project.", null, null), EXAMPLE_AVATAR_PARAM);
    private static final String AVATAR = "avatar";
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final String PUBLIC = "public";
    private static final String TYPE = "type";
    private static final String SCOPE = "scope";

    public RestProject() {
    }

    public RestProject(Project project) {
        this(project.getId(), project.getNamespace(), project.getKey(), project.getName(), project.getDescription(), project.getType(), project.isPublic());
    }

    RestProject(int id, String namespace, String key, String name, String description, ProjectType type, Boolean publiclyAccessible) {
        this.putIfNotNull(NAMESPACE, namespace);
        this.putIfNotNull(KEY, key);
        if (id > 0) {
            this.put(ID, id);
        }
        this.putIfNotNull(NAME, name);
        this.putIfNotNull(DESCRIPTION, description);
        this.putIfNotNull(PUBLIC, publiclyAccessible);
        if (type != null) {
            this.put(TYPE, type.name());
        }
    }

    private RestProject(int id, String namespace, String key, String name, String description, ProjectType type, Boolean publiclyAccessible, RestNamedLink selfLink) {
        this(id, namespace, key, name, description, type, publiclyAccessible);
        if (selfLink != null) {
            this.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", selfLink).build());
        }
    }

    private RestProject(int id, String key, String name, ProjectType type, boolean publiclyAccessible) {
        this(id, null, key, name, null, type, publiclyAccessible);
        this.put(SCOPE, ScopeType.PROJECT.name());
    }

    private RestProject(Map<String, Object> values) {
        super(values);
    }

    public <T> T accept(@Nonnull ProjectVisitor<T> visitor) {
        return (T)visitor.visit((Project)this);
    }

    public String getAvatar() {
        return StringUtils.trimToNull((String)this.getStringProperty(AVATAR));
    }

    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    public int getId() {
        return this.getIntProperty(ID);
    }

    @Nonnull
    public String getKey() {
        return this.getStringProperty(KEY);
    }

    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    public String getNamespace() {
        return this.getStringProperty(NAMESPACE);
    }

    @Nonnull
    public ProjectType getType() {
        return (ProjectType)this.getEnumProperty(TYPE, ProjectType.class);
    }

    public boolean hasAvatar() {
        return StringUtils.isNotBlank((CharSequence)this.getStringProperty(AVATAR));
    }

    public boolean hasPublic() {
        return this.get(PUBLIC) != null;
    }

    public boolean isPublic() {
        return this.getBoolProperty(PUBLIC);
    }

    @Override
    public void setAvatarUrl(String url) {
        this.put("avatarUrl", url);
    }

    public static RestProject fromProject(Project project) {
        if (project == null) {
            return null;
        }
        return (RestProject)project.accept(TRANSFORM_VISITOR);
    }

    public static RestProject simple(Project project) {
        if (project == null) {
            return null;
        }
        RestProject restProj = new RestProject();
        restProj.put(SCOPE, ScopeType.PROJECT.name());
        restProj.putIfNotNull(KEY, project.getKey());
        if (project.getId() > 0) {
            restProj.put(ID, project.getId());
        }
        restProj.putIfNotNull(NAME, project.getName());
        restProj.put(PUBLIC, project.isPublic());
        restProj.put(TYPE, project.getType().name());
        return restProj;
    }

    @Nullable
    public static RestProject valueOf(@Nullable Object value) {
        if (value instanceof RestProject) {
            return (RestProject)value;
        }
        if (value instanceof Map) {
            return new RestProject((Map)value);
        }
        return null;
    }
}

