/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.migration;

import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.migration.RestRepositorySelector;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestRepositoriesExportRequest
extends RestMapEntity {
    public static final String INCLUDES = "includes";
    @Deprecated
    public static final RestRepositoriesExportRequest REQUEST_EXAMPLE = new RestRepositoriesExportRequest(Sets.newHashSet((Object[])new RestRepositorySelector[]{RestRepositorySelector.REQUEST_EXAMPLE}));

    public RestRepositoriesExportRequest() {
    }

    public RestRepositoriesExportRequest(Set<RestRepositorySelector> includes) {
        this.put(INCLUDES, includes);
    }

    public RestRepositoriesExportRequest(RepositoriesExportRequest request) {
        this.put(INCLUDES, request.getIncludes().stream().map(include -> new RestRepositorySelector(include.getProjectKey(), include.getSlug())).collect(Collectors.toSet()));
    }

    public RestRepositoriesExportRequest(Map value) {
        super(value);
    }

    @NotNull
    @Nonnull
    @Valid
    public Set<RestRepositorySelector> getIncludes() {
        return Optional.ofNullable((List)this.get(INCLUDES)).map(includes -> includes.stream().map(RestRepositorySelector::valueOf).filter(Objects::nonNull).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Nullable
    public static RestRepositoriesExportRequest valueOf(@Nullable Object value) {
        if (value instanceof RestRepositoriesExportRequest) {
            return (RestRepositoriesExportRequest)((Object)value);
        }
        if (value instanceof Map) {
            return new RestRepositoriesExportRequest((Map)value);
        }
        return null;
    }
}

