/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.license;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.license.RestLicenseStatus;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.google.common.collect.ImmutableMap;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=BitbucketServerLicense.class)
public class RestBitbucketLicense
extends RestMapEntity {
    @Deprecated
    public static final RestBitbucketLicense RESPONSE_EXAMPLE = new RestBitbucketLicense(){
        {
            this.put(RestBitbucketLicense.CREATION_DATE, 1331038800000L);
            this.put(RestBitbucketLicense.PURCHASE_DATE, 1331038800000L);
            this.put(RestBitbucketLicense.EXPIRY_DATE, 1372493732817L);
            this.put(RestBitbucketLicense.DAYS_BEFORE_EXPIRY, 0);
            this.put(RestBitbucketLicense.MAINTENANCE_EXPIRY, 1372493732817L);
            this.put(RestBitbucketLicense.DAYS_BEFORE_MAINTENANCE_EXPIRY, 0);
            this.put(RestBitbucketLicense.GRACE_PERIOD_EXPIRY, 1372493732817L);
            this.put(RestBitbucketLicense.DAYS_BEFORE_GRACE_PERIOD_EXPIRY, 0);
            this.put(RestBitbucketLicense.MAXIMUM_NUMBER_OF_USERS, 12);
            this.put(RestBitbucketLicense.UNLIMITED_NuMBER_OF_USERS, false);
            this.put(RestBitbucketLicense.SERVER_ID, "<server ID embedded in license>");
            this.put(RestBitbucketLicense.SEN, "<support entitlement number embedded in license>");
            this.put(RestBitbucketLicense.LICENSE, "<encoded license text>");
            this.put(RestBitbucketLicense.STATUS, ImmutableMap.of((Object)RestBitbucketLicense.SERVER_ID, (Object)"<actual server ID>", (Object)"currentNumberOfUsers", (Object)2));
        }
    };
    @Deprecated
    public static final RestBitbucketLicense UPDATE_EXAMPLE = new RestBitbucketLicense(){
        {
            this.put(RestBitbucketLicense.LICENSE, "<encoded license text>");
        }
    };
    private static final String CREATION_DATE = "creationDate";
    private static final String DAYS_BEFORE_EXPIRY = "numberOfDaysBeforeExpiry";
    private static final String DAYS_BEFORE_GRACE_PERIOD_EXPIRY = "numberOfDaysBeforeGracePeriodExpiry";
    private static final String DAYS_BEFORE_MAINTENANCE_EXPIRY = "numberOfDaysBeforeMaintenanceExpiry";
    private static final String EXPIRY_DATE = "expiryDate";
    private static final String GRACE_PERIOD_EXPIRY = "gracePeriodEndDate";
    private static final String LICENSE = "license";
    private static final String MAINTENANCE_EXPIRY = "maintenanceExpiryDate";
    private static final String MAXIMUM_NUMBER_OF_USERS = "maximumNumberOfUsers";
    private static final String PURCHASE_DATE = "purchaseDate";
    private static final String SEN = "supportEntitlementNumber";
    private static final String SERVER_ID = "serverId";
    private static final String STATUS = "status";
    private static final String UNLIMITED_NuMBER_OF_USERS = "unlimitedNumberOfUsers";

    public RestBitbucketLicense() {
    }

    public RestBitbucketLicense(BitbucketServerLicense license) {
        this.put(CREATION_DATE, license.getCreationDate());
        this.put(PURCHASE_DATE, license.getPurchaseDate());
        this.put(EXPIRY_DATE, license.getExpiryDate());
        this.put(DAYS_BEFORE_EXPIRY, license.getNumberOfDaysBeforeExpiry());
        this.put(MAINTENANCE_EXPIRY, license.getMaintenanceExpiryDate());
        this.put(DAYS_BEFORE_MAINTENANCE_EXPIRY, license.getNumberOfDaysBeforeMaintenanceExpiry());
        this.put(GRACE_PERIOD_EXPIRY, license.getGracePeriodEndDate());
        this.put(DAYS_BEFORE_GRACE_PERIOD_EXPIRY, license.getNumberOfDaysBeforeGracePeriodExpiry());
        this.put(MAXIMUM_NUMBER_OF_USERS, license.isUnlimitedNumberOfUsers() ? -1 : license.getMaximumNumberOfUsers());
        this.put(UNLIMITED_NuMBER_OF_USERS, license.isUnlimitedNumberOfUsers());
        this.put(SERVER_ID, license.getServerId());
        this.put(SEN, license.getSupportEntitlementNumber());
    }

    public RestBitbucketLicense(BitbucketServerLicense license, String encodedLicense, RestLicenseStatus status) {
        this(license);
        this.put(LICENSE, encodedLicense);
        this.put(STATUS, (Object)status);
    }

    public String getLicense() {
        return this.getStringProperty(LICENSE);
    }
}

