/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.hook.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.scope.RestScope;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.util.MoreStreams;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=RepositoryHook.class)
public class RestRepositoryHook
extends RestMapEntity
implements RepositoryHook {
    public static final Function<RepositoryHook, RestRepositoryHook> REST_TRANSFORM = RestRepositoryHook::new;
    @Deprecated
    public static final RestRepositoryHook EXAMPLE = new RestRepositoryHook(new RestRepositoryHookDetails("com.atlassian.stash.plugin.example:example-repository-hook", "Example repository hook", RepositoryHookType.PRE_RECEIVE, "An example description for an example hook.", "1.2.4", null, (Iterable)ImmutableSet.of((Object)ScopeType.PROJECT, (Object)ScopeType.REPOSITORY)), true, true, RestScope.REPOSITORY_SCOPE_EXAMPLE);
    @Deprecated
    public static final RestPage<RestRepositoryHook> PAGE_EXAMPLE = RestDocUtils.pageOf(EXAMPLE);
    private static final String CONFIGURED = "configured";
    private static final String DETAILS = "details";
    private static final String ENABLED = "enabled";
    private static final String SCOPE = "scope";

    public RestRepositoryHook(RestRepositoryHookDetails details, boolean isEnabled, boolean configured, RestScope scope) {
        this.put(DETAILS, (Object)details);
        this.put(ENABLED, isEnabled);
        this.put(CONFIGURED, configured);
        this.put(SCOPE, (Object)scope);
    }

    public RestRepositoryHook(RepositoryHook descriptor) {
        this(new RestRepositoryHookDetails(descriptor.getDetails()), descriptor.isEnabled(), descriptor.isConfigured(), new RestScope(descriptor.getScope()));
    }

    @Nonnull
    public RepositoryHookDetails getDetails() {
        Object details = Objects.requireNonNull(this.get(DETAILS), DETAILS);
        if (details instanceof RepositoryHookDetails) {
            return (RepositoryHookDetails)details;
        }
        if (details instanceof Map) {
            return new RestRepositoryHookDetails((Map)details);
        }
        throw new IllegalStateException("details of type " + details.getClass().getName() + " are not supported");
    }

    @Nonnull
    public RestScope getScope() {
        return RestScope.valueOf(this.get(SCOPE));
    }

    public boolean isConfigured() {
        return this.getBoolProperty(CONFIGURED);
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }

    @JsonSerialize
    private static class RestRepositoryHookDetails
    extends RestMapEntity
    implements RepositoryHookDetails {
        private static final String KEY = "key";
        private static final String NAME = "name";
        private static final String TYPE = "type";
        private static final String DESCRIPTION = "description";
        private static final String VERSION = "version";
        private static final String CONFIG_FORM_KEY = "configFormKey";
        private static final String SCOPE_TYPES = "scopeTypes";

        private RestRepositoryHookDetails(Map<String, Object> map) {
            super(map);
        }

        public RestRepositoryHookDetails(RepositoryHookDetails details) {
            this(details.getKey(), details.getName(), details.getType(), details.getDescription(), details.getVersion(), details.getConfigFormKey(), details.getSupportedScopes());
        }

        private RestRepositoryHookDetails(String key, String name, RepositoryHookType type, String description, String version, String configFormKey, Iterable<ScopeType> scopeTypes) {
            this.put(KEY, key);
            this.put(NAME, name);
            this.put(TYPE, type);
            this.put(DESCRIPTION, description);
            this.put(VERSION, version);
            this.put(CONFIG_FORM_KEY, configFormKey);
            this.put(SCOPE_TYPES, scopeTypes);
        }

        public String getKey() {
            return this.getStringProperty(KEY);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public RepositoryHookType getType() {
            return (RepositoryHookType)this.getEnumProperty(TYPE, RepositoryHookType.class);
        }

        @Nullable
        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getVersion() {
            return this.getStringProperty(VERSION);
        }

        @Nullable
        public String getConfigFormKey() {
            return this.getStringProperty(CONFIG_FORM_KEY);
        }

        @Nonnull
        public Set<ScopeType> getSupportedScopes() {
            Iterable scopeTypes = (Iterable)this.get(SCOPE_TYPES);
            if (scopeTypes == null) {
                return Collections.emptySet();
            }
            return MoreStreams.streamIterable((Iterable)scopeTypes).map(scope -> {
                if (scope instanceof ScopeType) {
                    return (ScopeType)scope;
                }
                if (scope instanceof String) {
                    return ScopeType.valueOf((String)((String)scope));
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
    }
}

