/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.cluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.google.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.function.Function;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=ClusterNode.class)
public class RestClusterNode
extends RestMapEntity {
    public static final Function<ClusterNode, RestClusterNode> REST_TRANSFORM = RestClusterNode::new;

    public RestClusterNode(ClusterNode node) {
        InetSocketAddress socketAddress = node.getAddress();
        this.put("id", node.getId());
        this.put("buildVersion", node.getBuildVersion().toString());
        this.put("name", node.getName());
        this.put("address", ImmutableMap.of((Object)"hostName", (Object)socketAddress.getHostString(), (Object)"port", (Object)socketAddress.getPort()));
        this.put("local", node.isLocal());
    }
}

