/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.build;

import com.atlassian.bitbucket.build.status.TestResults;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestTestResults
extends RestMapEntity {
    private static final String FAILED = "failed";
    private static final String SKIPPED = "skipped";
    private static final String SUCCESSFUL = "successful";
    @Deprecated
    public static final RestTestResults EXAMPLE = new RestTestResults((Map<String, Object>)ImmutableMap.of((Object)"failed", (Object)1, (Object)"skipped", (Object)5, (Object)"successful", (Object)10));

    public RestTestResults() {
    }

    public RestTestResults(TestResults testResults) {
        if (testResults == null) {
            return;
        }
        testResults.getFailed().ifPresent(failed -> this.put(FAILED, failed));
        testResults.getSkipped().ifPresent(skipped -> this.put(SKIPPED, skipped));
        testResults.getSuccessful().ifPresent(successful -> this.put(SUCCESSFUL, successful));
    }

    public RestTestResults(Map<String, Object> value) {
        super(value);
    }

    public RestTestResults(Integer failed, Integer skipped, Integer successful) {
        this.putIfNotNull(FAILED, failed);
        this.putIfNotNull(SKIPPED, skipped);
        this.putIfNotNull(SUCCESSFUL, successful);
    }

    public Integer getFailed() {
        return this.getInteger(FAILED);
    }

    public Integer getSkipped() {
        return this.getInteger(SKIPPED);
    }

    public Integer getSuccessful() {
        return this.getInteger(SUCCESSFUL);
    }

    @Nullable
    public static RestTestResults valueOf(@Nullable Object testResults) {
        if (testResults instanceof RestTestResults) {
            return (RestTestResults)((Object)testResults);
        }
        if (testResults instanceof Map) {
            return new RestTestResults((Map)testResults);
        }
        return null;
    }

    private Integer getInteger(String failed2) {
        int failed = this.getIntProperty(failed2);
        if (failed < 0) {
            return null;
        }
        return failed;
    }
}

