/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.build;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.build.RestTestResults;
import java.util.Date;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestBuildStatusSetRequest
extends RestMapEntity {
    @Deprecated
    public static final RestBuildStatusSetRequest SUCCESSFUL_BUILD_EXAMPLE = new RestBuildStatusSetRequest("3", "TEST-REP123", "Unit test build", 1500000L, new Date(1359075920L), "Database Matrix Tests", "TEST-REP", "refs/heads/master", "SUCCESSFUL", new RestTestResults(1, 8, 0), "https://bamboo.url/browse/TEST-REP1-3");
    private static final String BUILD_NUMBER = "buildNumber";
    private static final int BUILD_NUMBER_MAX_LEN = 255;
    private static final String DESCRIPTION = "description";
    private static final int DESCRIPTION_MAX_LEN = 255;
    private static final String DURATION = "duration";
    private static final String KEY = "key";
    private static final int KEY_MAX_LEN = 255;
    private static final String LAST_UPDATED = "lastUpdated";
    private static final String NAME = "name";
    private static final int NAME_MAX_LEN = 255;
    private static final String PARENT = "parent";
    private static final int PARENT_MAX_LEN = 1024;
    private static final String REF = "ref";
    private static final int REF_MAX_LEN = 1024;
    private static final String STATE = "state";
    private static final String TEST_RESULTS = "testResults";
    private static final String URL = "url";
    private static final int URL_MAX_LEN = 450;

    public RestBuildStatusSetRequest() {
    }

    public RestBuildStatusSetRequest(RepositoryBuildStatusSetRequest request) {
        this.put(KEY, request.getKey());
        this.put(STATE, request.getState());
        this.put(URL, request.getUrl());
        this.putIfNotNull(BUILD_NUMBER, request.getBuildNumber());
        this.putIfNotNull(DESCRIPTION, request.getDescription());
        this.putIfNotNull(DURATION, request.getDuration());
        this.put(LAST_UPDATED, request.getLastUpdated());
        this.putIfNotNull(NAME, request.getName());
        this.putIfNotNull(PARENT, request.getParent());
        this.putIfNotNull(REF, request.getRef());
        if (request.getTestResults() != null) {
            this.put(TEST_RESULTS, (Object)new RestTestResults(request.getTestResults()));
        }
    }

    private RestBuildStatusSetRequest(String buildNumber, String key, String description, Long duration, Date lastUpdated, String name, String parent, String ref, String state, RestTestResults testResults, String url) {
        this.put(KEY, key);
        this.put(STATE, state);
        this.put(URL, url);
        this.putIfNotNull(BUILD_NUMBER, buildNumber);
        this.putIfNotNull(DESCRIPTION, description);
        this.putIfNotNull(DURATION, duration);
        if (lastUpdated != null) {
            this.put(LAST_UPDATED, lastUpdated.getTime());
        }
        this.putIfNotNull(NAME, name);
        this.putIfNotNull(PARENT, parent);
        this.putIfNotNull(REF, ref);
        this.putIfNotNull(TEST_RESULTS, (Object)testResults);
    }

    @Size(message="{bitbucket.rest.repository.build.status.buildNumber.oversized}", max=255)
    public @Size(message="{bitbucket.rest.repository.build.status.buildNumber.oversized}", max=255) String getBuildNumber() {
        return this.getStringProperty(BUILD_NUMBER);
    }

    public String getDescription() {
        return StringUtils.abbreviate((String)this.getStringProperty(DESCRIPTION), (int)255);
    }

    public Long getDuration() {
        long duration = this.getLongProperty(DURATION);
        if (duration < 0L) {
            return null;
        }
        return duration;
    }

    @Nullable
    public Long getLastUpdated() {
        try {
            return this.getLong(LAST_UPDATED);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @NotBlank(message="{bitbucket.rest.repository.build.status.key.invalid}")
    @Size(message="{bitbucket.rest.repository.build.status.key.invalid}", max=255)
    public @NotBlank(message="{bitbucket.rest.repository.build.status.key.invalid}") @Size(message="{bitbucket.rest.repository.build.status.key.invalid}", max=255) String getKey() {
        return this.getStringProperty(KEY);
    }

    @Size(message="{bitbucket.rest.repository.build.status.name.oversized}", max=255)
    public @Size(message="{bitbucket.rest.repository.build.status.name.oversized}", max=255) String getName() {
        return this.getStringProperty(NAME);
    }

    @Size(message="{bitbucket.rest.repository.build.status.parent.oversized}", max=1024)
    public @Size(message="{bitbucket.rest.repository.build.status.parent.oversized}", max=1024) String getParent() {
        return this.getStringProperty(PARENT);
    }

    @Size(message="{bitbucket.rest.repository.build.status.ref.oversized}", max=1024)
    @Pattern(regexp="^refs\\/.*", message="{bitbucket.rest.repository.build.status.ref.pattern}")
    public @Size(message="{bitbucket.rest.repository.build.status.ref.oversized}", max=1024) @Pattern(regexp="^refs\\/.*", message="{bitbucket.rest.repository.build.status.ref.pattern}") String getRef() {
        return this.getStringProperty(REF);
    }

    @NotNull(message="{bitbucket.rest.repository.build.status.state.error}")
    public @NotNull(message="{bitbucket.rest.repository.build.status.state.error}") BuildState getState() {
        return (BuildState)this.getEnumProperty(STATE, BuildState.class);
    }

    public RestTestResults getTestResults() {
        return RestTestResults.valueOf(this.get(TEST_RESULTS));
    }

    @NotBlank(message="{bitbucket.rest.repository.build.status.url.required}")
    @Size(message="{bitbucket.rest.repository.build.status.url.oversized}", max=450)
    public @NotBlank(message="{bitbucket.rest.repository.build.status.url.required}") @Size(message="{bitbucket.rest.repository.build.status.url.oversized}", max=450) String getUrl() {
        return this.getStringProperty(URL);
    }

    private Long getLong(String property) throws NumberFormatException {
        Object value = this.get(property);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return null;
    }
}

