/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Objects;

public class RestUserRateLimitSettings
extends RestMapEntity {
    public static final RestUserRateLimitSettings EXAMPLE_RESPONSE_SETTINGS = new RestUserRateLimitSettings(RestApplicationUser.RESPONSE_EXAMPLE, RestTokenBucketSettings.EXAMPLE);
    public static final RestUserRateLimitSettings EXAMPLE_RESPONSE_WHITELISTED = new RestUserRateLimitSettings(RestApplicationUser.RESPONSE_EXAMPLE, true);
    public static final RestPage<RestUserRateLimitSettings> EXAMPLE_PAGE = RestDocUtils.pageOf(EXAMPLE_RESPONSE_SETTINGS, EXAMPLE_RESPONSE_WHITELISTED);
    public static final String SETTINGS = "settings";
    public static final String USER = "user";
    public static final String WHITELISTED = "whitelisted";

    public RestUserRateLimitSettings() {
    }

    public RestUserRateLimitSettings(RestApplicationUser user, RestTokenBucketSettings settings) {
        this.put(USER, user);
        this.put(SETTINGS, (Object)settings);
    }

    public RestUserRateLimitSettings(RestApplicationUser user, boolean whitelisted) {
        this.put(USER, user);
        this.put(WHITELISTED, whitelisted);
    }

    public RestUserRateLimitSettings(ApplicationUser user, TokenBucketSettings settings) {
        this(new RestApplicationUser(user), new RestTokenBucketSettings(settings));
    }

    public RestUserRateLimitSettings(ApplicationUser user, boolean whitelisted) {
        this(new RestApplicationUser(user), whitelisted);
    }

    public RestUserRateLimitSettings(UserRateLimitSettings userRateLimitSettings) {
        this.put(USER, new RestApplicationUser(userRateLimitSettings.getUser()));
        if (userRateLimitSettings.isWhitelisted()) {
            this.put(WHITELISTED, true);
        } else {
            this.put(SETTINGS, (Object)userRateLimitSettings.getSettings().map(RestTokenBucketSettings::new).get());
        }
    }

    public RestTokenBucketSettings getSettings() {
        return RestTokenBucketSettings.valueOf(this.get(SETTINGS));
    }

    public RestApplicationUser getUser() {
        Object user = this.get(USER);
        return RestApplicationUser.valueOf(Objects.requireNonNull(user, USER));
    }

    public boolean hasSettings() {
        return this.get(SETTINGS) != null;
    }

    public boolean isWhitelisted() {
        return this.getBoolProperty(WHITELISTED);
    }
}

