/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.ratelimit.RestTokenBucketSettings;
import java.util.Locale;
import java.util.Objects;

public class RestRateLimitSettings
extends RestMapEntity {
    public static final RestRateLimitSettings RESPONSE_EXAMPLE = new RestRateLimitSettings(true, RestTokenBucketSettings.EXAMPLE);
    public static final String DEFAULT_SETTINGS = "defaultSettings";
    public static final String ENABLED = "enabled";

    public RestRateLimitSettings() {
    }

    public RestRateLimitSettings(boolean rateLimitEnabled, RestTokenBucketSettings restTokenBucketSettings) {
        this.put(ENABLED, rateLimitEnabled);
        this.put(DEFAULT_SETTINGS, (Object)restTokenBucketSettings);
    }

    public RestRateLimitSettings(boolean rateLimitEnabled, TokenBucketSettings tokenBucketSettings) {
        this.put(ENABLED, rateLimitEnabled);
        this.put(DEFAULT_SETTINGS, (Object)new RestTokenBucketSettings(tokenBucketSettings.getCapacity(), tokenBucketSettings.getFillRate()));
    }

    public RestTokenBucketSettings getDefaultSettings() {
        return RestTokenBucketSettings.valueOf(this.get(DEFAULT_SETTINGS));
    }

    public Boolean getEnabled() {
        Object enabled = this.get(ENABLED);
        if (enabled instanceof Boolean) {
            return (Boolean)enabled;
        }
        if (enabled instanceof String) {
            String enabledString = ((String)enabled).toLowerCase(Locale.ROOT);
            if (Objects.equals(Boolean.TRUE.toString(), enabledString)) {
                return true;
            }
            if (Objects.equals(Boolean.FALSE.toString(), enabledString)) {
                return false;
            }
        }
        return null;
    }

    public boolean hasDefaultSettings() {
        return this.get(DEFAULT_SETTINGS) != null;
    }

    public boolean hasEnabled() {
        return this.get(ENABLED) != null;
    }
}

