/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.webhook;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.webhook.history.RestInvocationHistory;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestWebhook
extends RestMapEntity {
    private static final String ACTIVE = "active";
    private static final String CONFIGURATION = "configuration";
    private static final String CREATED_DATE = "createdDate";
    private static final String EVENTS = "events";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String STATISTICS = "statistics";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String URL = "url";
    private static final Date exampleDate = Date.from(Instant.ofEpochSecond(1513106011L));
    public static RestWebhook EXAMPLE = new RestWebhook(10, "Webhook Name", exampleDate, exampleDate, (Set<String>)ImmutableSet.of((Object)"repo:refs_updated", (Object)"repo:modified"), (Map<String, String>)ImmutableMap.of((Object)"secret", (Object)"password"), "http://example.com", true);
    public static RestPage<RestWebhook> EXAMPLE_PAGE = RestDocUtils.pageOf(EXAMPLE);

    public RestWebhook() {
    }

    public RestWebhook(Webhook webhook) {
        if (webhook.getId() > 0) {
            this.put(ID, webhook.getId());
        }
        this.put(NAME, webhook.getName());
        this.put(CREATED_DATE, webhook.getCreatedDate());
        this.put(UPDATED_DATE, webhook.getUpdatedDate());
        this.put(EVENTS, webhook.getEvents().stream().map(WebhookEvent::getId).collect(MoreCollectors.toImmutableSet()));
        this.put(CONFIGURATION, webhook.getConfiguration());
        this.put(URL, webhook.getUrl());
        this.put(ACTIVE, webhook.isActive());
    }

    private RestWebhook(int id, String name, Date createdDate, Date updatedDate, Set<String> events, Map<String, String> configuration, String url, boolean isActive) {
        this.put(ID, id);
        this.put(NAME, name);
        this.put(CREATED_DATE, createdDate);
        this.put(UPDATED_DATE, updatedDate);
        this.put(EVENTS, events);
        this.put(CONFIGURATION, configuration);
        this.put(URL, url);
        this.put(ACTIVE, isActive);
    }

    @Nullable
    public Boolean getActive() {
        Object value = this.get(ACTIVE);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    @Nonnull
    public Map<String, String> getConfiguration() {
        Object config = this.get(CONFIGURATION);
        if (config instanceof Map) {
            return (Map)config;
        }
        return Collections.emptyMap();
    }

    @Nonnull
    public Set<String> getEvents() {
        Object events = this.get(EVENTS);
        if (events instanceof Collection) {
            return new HashSet<String>((Collection)events);
        }
        return Collections.emptySet();
    }

    public String getName() {
        return StringUtils.trimToNull((String)this.getStringProperty(NAME));
    }

    public String getUrl() {
        return StringUtils.trimToNull((String)this.getStringProperty(URL));
    }

    public void setStatistics(RestInvocationHistory statistics) {
        this.putIfNotNull(STATISTICS, (Object)statistics);
    }
}

