/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.cluster;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.cluster.RestClusterNode;
import com.atlassian.bitbucket.util.Chainable;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=ClusterInformation.class)
public class RestClusterInformation
extends RestMapEntity {
    public static final RestClusterInformation EXAMPLE = new RestClusterInformation(new ExampleClusterInformation());

    public RestClusterInformation(ClusterInformation information) {
        this.put("localNode", (Object)new RestClusterNode(information.getLocalNode()));
        this.put("nodes", Chainable.chain((Iterable)information.getNodes()).transform(RestClusterNode.REST_TRANSFORM::apply).toSet());
        this.put("running", information.isRunning());
    }

    private static class ExampleClusterInformation
    implements ClusterInformation {
        private ExampleClusterInformation() {
        }

        @Nonnull
        public ClusterNode getLocalNode() {
            return new ExampleClusterNode(InetSocketAddress.createUnresolved("foo", 5000), "d4fde8b1-2504-4998-a0ba-14fbe98edd4d", true, true, "foo", "9e9cc282-cb00-4942-bb51-77c2ea879e66");
        }

        @Nonnull
        public Set<ClusterNode> getNodes() {
            return new HashSet<ClusterNode>(){
                {
                    this.add(new ExampleClusterNode(InetSocketAddress.createUnresolved("foo", 5000), "d4fde8b1-2504-4998-a0ba-14fbe98edd4d", true, true, "foo", "9e9cc282-cb00-4942-bb51-77c2ea879e66"));
                    this.add(new ExampleClusterNode(InetSocketAddress.createUnresolved("bar", 5001), "73518909-8e86-445b-8345-fcbf2e0934b6", false, true, "bar", "25b7ff14-a881-42ba-afc2-40cd182055f7"));
                }
            };
        }

        public boolean isRunning() {
            return true;
        }

        private static class ExampleClusterNode
        implements ClusterNode {
            private InetSocketAddress address;
            private String id;
            private boolean isFullyStarted;
            private boolean isLocal;
            private String name;
            private String vmId;

            public ExampleClusterNode(InetSocketAddress address, String id, boolean isFullyStarted, boolean isLocal, String name, String vmId) {
                this.address = address;
                this.id = id;
                this.isFullyStarted = isFullyStarted;
                this.isLocal = isLocal;
                this.name = name;
                this.vmId = vmId;
            }

            @Nonnull
            public InetSocketAddress getAddress() {
                return this.address;
            }

            @Nonnull
            public String getId() {
                return this.id;
            }

            public boolean isFullyStarted() {
                return this.isFullyStarted;
            }

            public boolean isLocal() {
                return this.isLocal;
            }

            @Nonnull
            public String getName() {
                return this.name;
            }

            @Nonnull
            public String getVmId() {
                return this.vmId;
            }
        }
    }
}

