/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequestRef.class)
public class RestPullRequestRef
extends RestMapEntity {
    private static final String ID = "id";
    private static final String DISPLAY_ID = "displayId";
    private static final String LATEST_COMMIT = "latestCommit";
    private static final String REPOSITORY = "repository";
    public static final RestPullRequestRef REQUEST_MASTER_EXAMPLE = new RestPullRequestRef("refs/heads/master", null, null, RestRepository.REQUEST_EXAMPLE_WITH_PROJECT);
    public static final RestPullRequestRef RESPONSE_MASTER_EXAMPLE = new RestPullRequestRef("refs/heads/master", "master", "cafebabecafebabecafebabecafebabecafebabe", RestRepository.RESPONSE_EXAMPLE);
    public static final RestPullRequestRef REQUEST_FEATURE_EXAMPLE = new RestPullRequestRef("refs/heads/feature-ABC-123", null, null, RestRepository.REQUEST_EXAMPLE_WITH_PROJECT);
    public static final RestPullRequestRef RESPONSE_FEATURE_EXAMPLE = new RestPullRequestRef("refs/heads/feature", "feature-ABC-123", "babecafebabecafebabecafebabecafebabecafe", RestRepository.RESPONSE_EXAMPLE);

    public RestPullRequestRef(PullRequestRef ref) {
        this(ref.getId(), ref.getDisplayId(), ref.getLatestCommit(), new RestRepository(ref.getRepository(), true));
    }

    public RestPullRequestRef(String refId, String displayId, String latestCommit, RestRepository repository) {
        this.put(ID, refId);
        this.putIfNotNull(DISPLAY_ID, displayId);
        this.putIfNotNull(LATEST_COMMIT, latestCommit);
        this.put(REPOSITORY, (Object)repository);
    }

    private RestPullRequestRef(Map<String, Object> values) {
        super(values);
    }

    public RestRepository getRepository() {
        return RestRepository.valueOf(this.get(REPOSITORY));
    }

    @Nonnull
    public String getId() {
        return this.getStringProperty(ID);
    }

    public static RestPullRequestRef valueOf(Object value) {
        if (value instanceof RestPullRequestRef) {
            return (RestPullRequestRef)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequestRef((Map)value);
        }
        return null;
    }
}

