/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Deprecated
@JsonSerialize
public class RestErrors
extends RestMapEntity {
    public static final String ERRORS = "errors";

    public RestErrors() {
        this.put(ERRORS, new ArrayList());
    }

    public RestErrors(Collection<RestErrorMessage> errors) {
        this.put(ERRORS, new ArrayList<RestErrorMessage>(errors));
    }

    public RestErrors(String error) {
        this(new RestErrorMessage(error));
    }

    public RestErrors(String context, String error) {
        this(new RestErrorMessage(context, error, null));
    }

    public RestErrors(ServiceException e) {
        this(new RestErrorMessage(e));
    }

    public RestErrors(RestErrorMessage message) {
        this(Collections.singletonList(message));
    }

    public boolean endScopeAndTryWriteTo(StatefulJsonWriter writer) throws IOException {
        StatefulJsonWriter.WritingState writingState = writer.endToDocument().getWritingState();
        if (writingState.getContext() == StatefulJsonWriter.WritingContext.ROOT && writingState.getEntryCount() == 0) {
            writer.beginObject();
            this.writeErrors(writer);
            writer.endObject();
            return true;
        }
        if (writingState.getContext() == StatefulJsonWriter.WritingContext.OBJECT) {
            this.writeErrors(writer);
            writer.endObject();
            return true;
        }
        return false;
    }

    public List<RestErrorMessage> getErrors() {
        return this.getRawErrors().stream().map(RestErrorMessage::valueOf).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<?> getRawErrors() {
        return (List)this.get(ERRORS);
    }

    private void writeErrors(StatefulJsonWriter writer) throws IOException {
        writer.name(ERRORS);
        writer.beginArray();
        for (RestErrorMessage message : this.getErrors()) {
            writer.value(message);
        }
        writer.endArray();
    }

    public static class Builder {
        private final ImmutableList.Builder<RestErrorMessage> errorsBuilder = ImmutableList.builder();

        public Builder add(String value) {
            this.errorsBuilder.add((Object)new RestErrorMessage(value));
            return this;
        }

        public Builder add(RestErrorMessage value) {
            this.errorsBuilder.add((Object)value);
            return this;
        }

        public Builder addErrors(Iterable<String> values) {
            this.errorsBuilder.addAll(Iterables.transform(values, RestErrorMessage::new));
            return this;
        }

        public Builder addErrorMessages(Iterable<RestErrorMessage> values) {
            this.errorsBuilder.addAll(values);
            return this;
        }

        public RestErrors build() {
            return new RestErrors((Collection<RestErrorMessage>)this.errorsBuilder.build());
        }
    }
}

