/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest;

import com.atlassian.bitbucket.rest.content.RestPath;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class RestMapEntity
extends LinkedHashMap<String, Object> {
    public RestMapEntity() {
    }

    public RestMapEntity(Map<String, ?> values) {
        super(values);
    }

    protected static <F, T> List<T> transform(Iterable<F> values, Function<F, T> transformer) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(values, transformer));
    }

    protected static <F, T> Set<T> transform(Set<F> values, Function<F, T> transformer) {
        return ImmutableSet.copyOf((Collection)Collections2.transform(values, transformer));
    }

    protected <T extends Enum<T>> T getEnumProperty(String property, Class<T> enumClass) {
        Object value = this.get(property);
        if (enumClass.isInstance(value)) {
            return (T)((Enum)enumClass.cast(value));
        }
        if (value instanceof String) {
            return Enum.valueOf(enumClass, ((String)value).toUpperCase(Locale.US));
        }
        return null;
    }

    protected int getIntProperty(String property) {
        Object value = this.get(property);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return -1;
    }

    protected boolean getBoolProperty(String property) {
        return this.getBoolProperty(property, false);
    }

    protected boolean getBoolProperty(String property, boolean defaultValue) {
        Object value = this.get(property);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return defaultValue;
    }

    protected long getLongProperty(String property) {
        Object value = this.get(property);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return -1L;
    }

    protected RestPath getPathProperty(String property) {
        Object value = this.get(property);
        if (value instanceof RestPath) {
            return (RestPath)value;
        }
        if (value instanceof String) {
            return new RestPath((String)value);
        }
        return null;
    }

    protected String getStringProperty(String property) {
        return (String)this.get(property);
    }

    protected void putIfNotEmpty(String key, Collection<?> value) {
        if (value != null && !value.isEmpty()) {
            this.put(key, value);
        }
    }

    protected void putIfNotEmpty(String key, Iterable<?> value) {
        if (value != null && !Iterables.isEmpty(value)) {
            this.put(key, value);
        }
    }

    protected void putIfNotEmpty(String key, Map<?, ?> value) {
        if (value != null && !value.isEmpty()) {
            this.put(key, value);
        }
    }

    protected void putIfNotNull(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }
}

