define('bitbucket/internal/feature/sync/dialog/ref-sync-dialog', [
    'aui',
    'jquery',
    'lodash',
    'bitbucket/util/navbuilder',
    'bitbucket/internal/feature/sync/common/ref-sync-common',
    'bitbucket/internal/model/page-state',
    'bitbucket/internal/util/ajax',
    'bitbucket/internal/widget/submit-spinner',
], function(
    AJS,
    $,
    _,
    nav,
    refSyncCommon,
    pageState,
    ajax,
    SubmitSpinner
) {
    'use strict';

    function getCloneUrl(repo) {
        return nav.project(repo.getProject()).repo(repo).clone(repo.getScmId()).buildAbsolute();
    }

    function RefSyncDialog() {
        this.initDialog();
    }

    RefSyncDialog.prototype.initDialog = function() {
        var self = this;
        var spinner;

        this.ref = pageState.getRevisionRef();

        this.dialog = new AJS.Dialog({
            width: 840,
            height: 420,
            closeOnOutsideClick: true,
        });
        _.bindAll(this.dialog, 'hide');  // wtf, dialog should be doing this!
        this.dialog.popup.element.addClass('ref-sync-dialog');
        this.dialog.addHeader()
            .addPanel()
            .addSubmit('', function() {
                spinner.show();
                self.doSynchronization().fail(function() {
                    spinner.hide();
                }).done(function() {
                    window.location.reload(true);
                });
            })
            .addCancel(AJS.I18n.getText('bitbucket.web.button.cancel'), this.dialog.hide);

        this.$syncPanel = this.dialog.getCurrentPanel().body;
        this.$syncPanel.on('click', '.option', function() {
            self.$syncPanel.find('.selected').removeClass('selected');
            var $selectedAction = $(this);
            $selectedAction.addClass('selected');
            self._setAction($selectedAction);
        });

        var $submit = this.dialog.getCurrentPanel().page.buttonpanel.find('.button-panel-submit-button');
        $submit.addClass('aui-button aui-button-primary').removeClass('button-panel-button');        // Hack to change to a primary button
        spinner = new SubmitSpinner($submit, 'before');
    };

    RefSyncDialog.prototype.doSynchronization = function() {
        var self = this;
        return ajax.rest({
            url: refSyncCommon.getSyncUrl(),
            type: 'POST',
            data: {
                action: this.action,
                refId: this.ref.getId(),
            },
            statusCode: {
                409: function(xhr, textStatus, errorThrown, data) {
                    // File conflicts when performing merge
                    self.dialog.addPage('merge-conflict')
                        .addHeader(AJS.I18n.getText('bitbucket.refsync.dialog.title.merge.conflicts'))
                        .addPanel()
                        .addButtonPanel()
                        .addCancel(AJS.I18n.getText('bitbucket.web.button.close'), self.dialog.hide);

                    $(document).one('hideLayer', function() {
                        self.dialog.prevPage()
                            .page.pop()         // Remove the merge-conflict page object
                            .body.remove();     // Delete the $page in the dom
                    });

                    var $panel = self.dialog.getCurrentPanel().body;
                    $panel.append(bitbucket.internal.feature.sync.mergeConflictHelp({
                        conflicts: data.conflicts,
                        branchName: self.ref.getDisplayId(),
                        upstreamRemote: getCloneUrl(pageState.getRepository().getOrigin()),
                        forkRemote: getCloneUrl(pageState.getRepository()),
                    }));
                    self.dialog.updateHeight();

                    return false;
                },
            },
        });
    };

    RefSyncDialog.prototype._setAction = function($selectedAction) {
        this.action = $selectedAction.attr('data-option');
        var $buttonpanel = this.dialog.getCurrentPanel().page.buttonpanel;
        var $submit = $buttonpanel.find('.button-panel-submit-button');
        $submit.text($selectedAction.find('.option-name').text());

        // Additional warning for discarding
        $('.discard-warning').remove();
        if (this.action === 'discard') {
            $buttonpanel.prepend(bitbucket.internal.feature.sync.discardWarning());
        }
    };

    RefSyncDialog.prototype.showFor = function(ref) {
        this.ref = ref;
        this.dialog.addHeader(AJS.I18n.getText('bitbucket.refsync.dialog.title', ref.getDisplayId()));
        this.$syncPanel.html(bitbucket.internal.feature.sync.dialog({
            ref: ref.toJSON(),
        }));
        this._setAction(this.$syncPanel.find('.selected'));
        this.dialog.show();
        this.dialog.updateHeight();
    };

    return RefSyncDialog;
});
