/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.web;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.repository.sync.DefaultRefSyncService;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RefSyncServlet
extends HttpServlet {
    private final RepositoryService repositoryService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final InternalRefSyncService syncService;
    private final PermissionValidationService validationService;

    public RefSyncServlet(RepositoryService repositoryService, SoyTemplateRenderer soyTemplateRenderer, InternalRefSyncService syncService, PermissionValidationService validationService) {
        this.repositoryService = repositoryService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.syncService = syncService;
        this.validationService = validationService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (Strings.isNullOrEmpty((String)pathInfo) || pathInfo.equals("/")) {
            resp.sendError(404);
            return;
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        if (pathParts.length != 2) {
            resp.sendError(404);
            return;
        }
        Repository repository = this.repositoryService.getBySlug(pathParts[0], pathParts[1]);
        if (repository == null) {
            resp.sendError(404);
            return;
        }
        this.validationService.validateForRepository(repository, Permission.REPO_ADMIN);
        HashMap context = Maps.newHashMap();
        context.put("repository", repository);
        context.put("upstream", repository.getOrigin());
        context.put("owner", repository.getProject().accept(DefaultRefSyncService.TO_OWNER));
        RefSyncStatus status = this.syncService.getStatus(repository);
        if (status == null) {
            context.put("syncingAvailable", this.syncService.isAvailable(repository));
        } else {
            context.put("syncingAvailable", status.isAvailable());
            context.put("syncStatus", status);
        }
        this.render(resp, "com.atlassian.bitbucket.server.bitbucket-repository-ref-sync:server-soy-templates", "bitbucket.internal.page.settings.refSyncSettings", context);
    }

    private void render(HttpServletResponse resp, String resourceKey, String template, Map<String, Object> context) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), resourceKey, template, context);
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }
}

