/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.ui;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncService;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class EnableRefSyncingFormFragment
implements ContextualFormFragment {
    private static final String FIELD_KEY = "enable-ref-syncing";
    private static final boolean REF_SYNC_DEFAULT = true;
    private static final String SOY_PARAM_ENABLED = "enabled";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final RefSyncService syncService;

    public EnableRefSyncingFormFragment(SoyTemplateRenderer soyTemplateRenderer, RefSyncService syncService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.syncService = syncService;
    }

    public void doError(@Nonnull Appendable appendable, @Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        context.put(SOY_PARAM_ENABLED, this.isCheckBoxEnabled(requestParams));
        this.renderView(appendable, context);
    }

    public void doView(@Nonnull Appendable appendable, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(context, "context");
        context.put(SOY_PARAM_ENABLED, true);
        this.renderView(appendable, context);
    }

    public void execute(@Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Object> context) {
        Objects.requireNonNull(requestParams, "requestParams");
        Objects.requireNonNull(context, "context");
        Repository repository = (Repository)context.get("fork");
        this.syncService.setEnabled(repository, this.isCheckBoxEnabled(requestParams));
    }

    public void validate(@Nonnull Map<String, String[]> requestParams, @Nonnull ValidationErrors errors, @Nonnull Map<String, Object> context) {
    }

    private boolean isCheckBoxEnabled(Map<String, String[]> requestParams) {
        String[] values = requestParams.get(FIELD_KEY);
        return values != null && values.length == 1 && values[0].equalsIgnoreCase("on");
    }

    private void renderView(Appendable appendable, Map<String, Object> context) {
        try {
            this.soyTemplateRenderer.render(appendable, "com.atlassian.bitbucket.server.bitbucket-repository-ref-sync:server-soy-templates", "bitbucket.internal.feature.sync.enableRefSync", context);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render bitbucket.internal.feature.sync.enableRefSync", (Throwable)e);
        }
    }
}

