/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.stp;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncService;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.support.tools.spi.SupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;
import java.text.DateFormat;
import java.util.Locale;

public class RefSyncSupportInfoAppender
implements SupportInfoAppender<Repository> {
    private static final DateFormat FORMAT = DateFormat.getDateTimeInstance(0, 0, Locale.US);
    private static final String REF_SYNC = "stp.properties.stash.refsync";
    private static final String REF_SYNC_AHEAD = "stp.properties.stash.refsync.ahead";
    private static final String REF_SYNC_DIVERGED = "stp.properties.stash.refsync.diverged";
    private static final String REF_SYNC_ENABLED = "stp.properties.stash.refsync.enabled";
    private static final String REF_SYNC_LAST_SYNC = "stp.properties.stash.refsync.lastsync";
    private static final String REF_SYNC_ORPHANED = "stp.properties.stash.refsync.orphaned";
    private final RefSyncService refSyncService;

    public RefSyncSupportInfoAppender(RefSyncService refSyncService) {
        this.refSyncService = refSyncService;
    }

    public void addSupportInfo(SupportInfoBuilder builder, Repository repository) {
        RefSyncStatus status = this.refSyncService.getStatus(repository);
        if (status == null) {
            return;
        }
        SupportInfoBuilder refSync = builder.addCategory(REF_SYNC);
        refSync.addValue(REF_SYNC_ENABLED, Boolean.toString(status.isEnabled()));
        refSync.addValue(REF_SYNC_LAST_SYNC, FORMAT.format(status.getLastSync()));
        if (status.isEnabled()) {
            refSync.addValue(REF_SYNC_AHEAD, Integer.toString(status.getAheadRefs().size()));
            refSync.addValue(REF_SYNC_DIVERGED, Integer.toString(status.getDivergedRefs().size()));
            refSync.addValue(REF_SYNC_ORPHANED, Integer.toString(status.getOrphanedRefs().size()));
        }
    }
}

