/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.sync.RefSyncRequest;
import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.atlassian.stash.internal.repository.sync.rest.RestRefSyncRequest;
import com.atlassian.stash.internal.repository.sync.rest.RestRefSyncStatus;
import com.atlassian.stash.internal.repository.sync.rest.RestRejectedRef;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class RefSyncResource {
    private final I18nService i18nService;
    private final InternalRefSyncService syncService;

    public RefSyncResource(I18nService i18nService, InternalRefSyncService syncService) {
        this.i18nService = i18nService;
        this.syncService = syncService;
    }

    @GET
    public Response getStatus(@Context Repository repository, @QueryParam(value="at") String refId) {
        if (StringUtils.isNotBlank((CharSequence)refId)) {
            return this.getRefStatus(repository, refId);
        }
        return this.getRepositoryStatus(repository);
    }

    @POST
    public Response setEnabled(@Context Repository repository, RestRefSyncStatus restStatus) {
        if (restStatus.containsKey("enabled")) {
            boolean enabled = restStatus.isEnabled();
            this.syncService.setEnabled(repository, enabled);
            return this.getRepositoryStatus(repository);
        }
        throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.refsync.enablenotprovided", new Object[]{"enabled"}));
    }

    @POST
    @Path(value="/synchronize")
    public Response synchronize(@Context Repository repository, RestRefSyncRequest restSyncRequest) {
        String refId = restSyncRequest.getRefId();
        this.syncService.synchronize(new RefSyncRequest.Builder().action(restSyncRequest.getAction()).context(restSyncRequest.getContext()).refId(refId).repository(repository).build());
        return this.getRefStatus(repository, refId);
    }

    private Response getRefStatus(Repository repository, String refId) {
        RejectedRef status = this.syncService.getStatus(repository, refId);
        if (status == null) {
            return ResponseFactory.noContent().build();
        }
        return ResponseFactory.ok((Object)((Object)new RestRejectedRef(status))).build();
    }

    private Response getRepositoryStatus(Repository repository) {
        RefSyncStatus status = this.syncService.getStatus(repository);
        RestRefSyncStatus restStatus = status == null ? new RestRefSyncStatus(this.syncService.isAvailable(repository)) : new RestRefSyncStatus(status);
        return ResponseFactory.ok((Object)((Object)restStatus)).build();
    }
}

