/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.rest;

import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.exception.UnhandledExceptionMapper;
import com.atlassian.bitbucket.rest.exception.UnhandledExceptionMapperHelper;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.scm.git.command.merge.GitMergeException;
import com.atlassian.stash.internal.repository.sync.rest.RestMergeErrorMessage;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
@Singleton
public class RefSyncExceptionMapper
extends UnhandledExceptionMapper {
    public RefSyncExceptionMapper(UnhandledExceptionMapperHelper helper) {
        super(helper);
    }

    public Response toResponse(Exception exception) {
        if (exception instanceof UnsupportedOperationException) {
            return ResponseFactory.serverError().status(501).entity((Object)new RestErrorMessage(null, exception.getMessage())).build();
        }
        for (Throwable thrown = exception; thrown != null; thrown = thrown.getCause()) {
            if (!(thrown instanceof GitMergeException)) continue;
            return RefSyncExceptionMapper.toMergeResponse((GitMergeException)thrown);
        }
        return super.toResponse(exception);
    }

    private static Response toMergeResponse(GitMergeException exception) {
        return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)new RestMergeErrorMessage(exception)).build();
    }
}

