/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.git.GitAgent;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.stash.internal.repository.sync.RefSyncConfig;
import com.atlassian.stash.internal.repository.sync.command.AbstractFetchSynchronizeRefsCommand;
import com.atlassian.stash.internal.repository.sync.command.FetchCallback;
import com.atlassian.stash.internal.repository.sync.command.SynchronizeRefsCommandParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullSynchronizeRefsCommand
extends AbstractFetchSynchronizeRefsCommand {
    private static final Logger log = LoggerFactory.getLogger(FullSynchronizeRefsCommand.class);

    public FullSynchronizeRefsCommand(GitAgent agent, GitCommandBuilderFactory builderFactory, RefSyncConfig config, I18nService i18nService, SynchronizeRefsCommandParameters parameters) {
        super(agent, builderFactory, config, i18nService, parameters);
    }

    public String toString() {
        return ((SynchronizeRefsCommandParameters)this.parameters).getRepository().getId() + ": Full Synchronization";
    }

    @Override
    protected boolean synchronize() {
        this.runFetch(this.fetchBuilder().refspec(GitRefPattern.HEADS.getRefspec()), new FetchCallback(){

            @Override
            public void onChanged(@Nonnull RefChange change) {
                FullSynchronizeRefsCommand.this.addChangedRef(change);
            }

            @Override
            public void onRejected(@Nonnull String refId, @Nonnull RejectedRefState state) {
                if (state == RejectedRefState.DIVERGED) {
                    RejectedRefState check = FullSynchronizeRefsCommand.this.calculateState(refId);
                    if (check == null) {
                        log.warn("{} is unexpected in sync with ");
                        return;
                    }
                    state = check;
                }
                FullSynchronizeRefsCommand.this.addRejectedRef(refId, state);
            }
        });
        return true;
    }

    @Nullable
    private RejectedRefState calculateState(@Nonnull String refId) {
        Branch local = this.agent.resolveBranch(((SynchronizeRefsCommandParameters)this.parameters).getRepository(), refId, true);
        if (local == null) {
            return null;
        }
        return this.calculateState(refId, local.getLatestCommit());
    }
}

