/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.git.GitAgent;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRef;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefBuilderSupport;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefSetBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.repository.sync.command.DiscardRefCommandParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscardRefCommand
extends SimpleCommand<RefChange> {
    private static final Logger log = LoggerFactory.getLogger(DiscardRefCommand.class);
    private final GitAgent agent;
    private final GitCommandBuilderFactory builderFactory;
    private final String refId;
    private final Repository repository;
    private final Repository upstream;
    private final ApplicationUser user;

    public DiscardRefCommand(GitAgent agent, GitCommandBuilderFactory builderFactory, DiscardRefCommandParameters parameters) {
        this.agent = agent;
        this.builderFactory = builderFactory;
        this.refId = parameters.getRefId();
        this.repository = parameters.getRepository();
        this.upstream = parameters.getUpstream();
        this.user = parameters.getUser();
    }

    public RefChange call() {
        GitUpdateRefSetBuilder commandBuilder;
        Branch toBranch = this.agent.resolveBranch(this.repository, this.refId, true);
        if (toBranch == null) {
            log.debug("{}: {} has already been deleted", (Object)this.repository, (Object)this.refId);
            return null;
        }
        Branch fromBranch = this.agent.resolveBranch(this.upstream, this.refId, true);
        SimpleRefChange.Builder changeBuilder = new SimpleRefChange.Builder().from((Ref)toBranch);
        GitUpdateRef updateRef = this.builderFactory.builder(this.repository).updateRef();
        if (fromBranch == null) {
            log.debug("{}: Deleting {}, which has been deleted upstream in {}", new Object[]{this.repository, this.refId, this.upstream});
            changeBuilder.toHash(GitUtils.NULL_SHA1).type(RefChangeType.DELETE);
            commandBuilder = updateRef.delete(this.refId);
        } else {
            changeBuilder.to((Ref)fromBranch).type(RefChangeType.UPDATE);
            commandBuilder = updateRef.set(this.refId, fromBranch.getLatestCommit());
        }
        ((GitUpdateRefBuilderSupport)commandBuilder.author(this.user)).build().call();
        return changeBuilder.build();
    }
}

