/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.command;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.repository.sync.BulkRefSyncRequest;
import com.atlassian.stash.internal.repository.sync.command.AbstractCommandParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractRefsCommandParameters
extends AbstractCommandParameters
implements Iterable<RefChange> {
    protected final Collection<RefChange> refChanges;

    protected AbstractRefsCommandParameters(BulkRefSyncRequest request) {
        super(request.getRepository(), request.getUpstream(), request.getUser());
        this.refChanges = (Collection)Preconditions.checkNotNull(request.getRefChanges(), (Object)"refChanges");
    }

    protected AbstractRefsCommandParameters(Repository repository, Repository upstream, ApplicationUser user) {
        super(repository, upstream, user);
        this.refChanges = null;
    }

    @Override
    public Iterator<RefChange> iterator() {
        if (this.refChanges == null) {
            return Iterators.emptyIterator();
        }
        return this.refChanges.iterator();
    }

    public int size() {
        return this.refChanges == null ? 0 : this.refChanges.size();
    }
}

