/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.auto;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncOperation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.annotation.Nonnull;

public class AutoRefSyncRequest
implements Externalizable {
    private AutoRefSyncOperation operation;
    private List<RefChange> refChanges;
    private int repositoryId;
    private int upstreamId;
    private int userId;

    public AutoRefSyncRequest() {
    }

    private AutoRefSyncRequest(Builder builder) {
        this.operation = builder.operation;
        this.refChanges = builder.refChanges;
        this.repositoryId = builder.repositoryId;
        this.upstreamId = builder.upstreamId;
        this.userId = builder.userId;
    }

    public AutoRefSyncOperation getOperation() {
        return this.operation;
    }

    public List<RefChange> getRefChanges() {
        return this.refChanges;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int getUpstreamId() {
        return this.upstreamId;
    }

    public int getUserId() {
        return this.userId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.repositoryId = in.readInt();
        this.upstreamId = in.readInt();
        this.userId = in.readInt();
        this.operation = AutoRefSyncOperation.fromId(in.readInt());
        this.refChanges = this.readRefChanges(in, in.readInt());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.repositoryId);
        out.writeInt(this.upstreamId);
        out.writeInt(this.userId);
        out.writeInt(this.operation.getId());
        this.writeRefChanges(out);
    }

    private MinimalRef readRef(ObjectInput in) throws IOException {
        SimpleMinimalRef.Builder builder = (SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id(in.readUTF())).displayId(in.readUTF());
        try {
            builder.type((RefType)in.readObject());
        }
        catch (ClassNotFoundException e) {
            builder.type((RefType)StandardRefType.BRANCH);
        }
        return builder.build();
    }

    private List<RefChange> readRefChanges(ObjectInput in, int count) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            builder.add((Object)new SimpleRefChange.Builder().ref(this.readRef(in)).fromHash(in.readUTF()).toHash(in.readUTF()).type(RefChangeType.fromId((int)in.readInt())).build());
        }
        return builder.build();
    }

    private void writeRef(ObjectOutput out, MinimalRef ref) throws IOException {
        out.writeUTF(ref.getId());
        out.writeUTF(ref.getDisplayId());
        out.writeObject(ref.getType());
    }

    private void writeRefChanges(ObjectOutput out) throws IOException {
        out.writeInt(this.refChanges.size());
        for (RefChange refChange : this.refChanges) {
            this.writeRef(out, refChange.getRef());
            out.writeUTF(refChange.getFromHash());
            out.writeUTF(refChange.getToHash());
            out.writeInt(refChange.getType().getId());
        }
    }

    public static class Builder {
        private final List<RefChange> refChanges;
        private final int userId;
        private AutoRefSyncOperation operation;
        private int repositoryId;
        private int upstreamId;

        public Builder(@Nonnull List<RefChange> refChanges, @Nonnull ApplicationUser user) {
            this.refChanges = (List)Preconditions.checkNotNull(refChanges, (Object)"refChanges");
            this.userId = ((ApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId();
        }

        @Nonnull
        public AutoRefSyncRequest build() {
            Preconditions.checkState((this.repositoryId != 0 ? 1 : 0) != 0, (Object)"A repository ID is required");
            Preconditions.checkState((this.upstreamId != 0 ? 1 : 0) != 0, (Object)"An upstream repository ID is required");
            Preconditions.checkState((this.operation != null ? 1 : 0) != 0, (Object)"A RefSyncOperation is required");
            return new AutoRefSyncRequest(this);
        }

        @Nonnull
        public Builder operation(@Nonnull AutoRefSyncOperation value) {
            this.operation = (AutoRefSyncOperation)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"operation"));
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            this.repositoryId = Builder.extractId(value, "repository");
            return this;
        }

        @Nonnull
        public Builder upstream(@Nonnull Repository value) {
            this.upstreamId = Builder.extractId(value, "upstream");
            return this;
        }

        private static int extractId(Repository repository, String name) {
            return (Integer)Preconditions.checkNotNull((Object)((Repository)Preconditions.checkNotNull((Object)repository, (Object)name)).getId(), (String)"%s.id", (Object[])new Object[]{name});
        }
    }
}

