/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync.auto;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.repository.sync.BulkRefSyncRequest;
import com.atlassian.stash.internal.repository.sync.InternalRefSyncService;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncOperation;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncRequest;
import com.atlassian.stash.internal.repository.sync.auto.AutoRefSyncTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRefSyncProcessor
implements BucketProcessor<AutoRefSyncRequest> {
    private static final Logger log = LoggerFactory.getLogger(AutoRefSyncProcessor.class);
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final InternalRefSyncService syncService;
    private final UserService userService;

    public AutoRefSyncProcessor(PullRequestService pullRequestService, RepositoryService repositoryService, SecurityService securityService, InternalRefSyncService syncService, UserService userService) {
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.syncService = syncService;
        this.userService = userService;
    }

    public void process(@Nonnull String bucketId, @Nonnull List<AutoRefSyncRequest> tasks) {
        ApplicationUser user = this.findUser(tasks);
        if (user == null) {
            log.warn("Dropping {} request(s); no valid user could be found", (Object)tasks.size());
            return;
        }
        this.securityService.impersonating(user, "Processing ref sync").withPermission(Permission.REPO_WRITE).call(() -> {
            this.doProcess(user, tasks);
            return null;
        });
    }

    private void doProcess(ApplicationUser user, List<AutoRefSyncRequest> requests) {
        AutoRefSyncRequest first = requests.get(0);
        int repositoryId = first.getRepositoryId();
        Repository repository = this.repositoryService.getById(repositoryId);
        if (repository == null) {
            log.info("Dropping {} request(s); repository {} no longer exists", (Object)requests.size(), (Object)repositoryId);
            return;
        }
        int upstreamId = first.getUpstreamId();
        Repository upstream = this.repositoryService.getById(upstreamId);
        if (upstream == null) {
            log.info("{}: Dropping {} request(s); upstream repository {} no longer exists", new Object[]{repository, requests.size(), upstreamId});
            return;
        }
        for (AutoRefSyncTask task : AutoRefSyncTask.merge(requests)) {
            try {
                if (task.getOperation() == AutoRefSyncOperation.REVIEW) {
                    BulkRefSyncRequest request = new BulkRefSyncRequest(repository, upstream, user, task.getRefChanges());
                    this.syncService.updateStatus(request);
                    continue;
                }
                Collection<RefChange> refChanges = this.filterBranchDeletionsInPullRequests(repository, task.getRefChanges());
                if (refChanges.isEmpty()) continue;
                BulkRefSyncRequest request = new BulkRefSyncRequest(repository, upstream, user, refChanges);
                this.syncService.synchronize(request);
            }
            catch (RuntimeException e) {
                log.warn("{}: Could not {} changes with {}", new Object[]{repository, task.getOperation(), upstream, e});
            }
        }
    }

    private Collection<RefChange> filterBranchDeletionsInPullRequests(Repository repository, Collection<RefChange> refChanges) {
        Set refsToDelete = Chainable.chain(refChanges).filter(refChange -> refChange.getType().equals((Object)RefChangeType.DELETE)).transform(ref -> ref.getRef().getId()).toSet();
        if (refsToDelete.isEmpty()) {
            return refChanges;
        }
        HashMap refIdToRefChanges = new HashMap(Maps.uniqueIndex(refChanges, change -> change.getRef().getId()));
        Iterable refsToDeleteBatches = Iterables.partition((Iterable)refsToDelete, (int)100);
        for (List refs : refsToDeleteBatches) {
            PullRequestSearchRequest searchRequest = new PullRequestSearchRequest.Builder().fromRepositoryId(Integer.valueOf(repository.getId())).fromRefIds((Iterable)refs).state(PullRequestState.OPEN).build();
            for (PullRequest pullRequest : new PagedIterable(request -> this.pullRequestService.search(searchRequest, request), 500)) {
                refIdToRefChanges.remove(pullRequest.getFromRef().getId());
            }
        }
        return ImmutableList.copyOf(refIdToRefChanges.values());
    }

    private ApplicationUser findUser(List<AutoRefSyncRequest> tasks) {
        for (AutoRefSyncRequest task : tasks) {
            ApplicationUser user = this.userService.getUserById(task.getUserId());
            if (user == null) continue;
            return user;
        }
        return null;
    }
}

