/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.bitbucket.repository.sync.RejectedRefState;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.stash.internal.repository.sync.dao.AoRejectedRef;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class SimpleRejectedRef
extends SimpleMinimalRef
implements RejectedRef {
    private final RejectedRefState state;

    private SimpleRejectedRef(Builder builder) {
        super((SimpleMinimalRef.AbstractMinimalRefBuilder)builder, builder.type);
        this.state = builder.state;
    }

    public static boolean isNote(String name) {
        return name.startsWith("refs/notes/");
    }

    public static boolean isTag(String name) {
        return name.startsWith(GitRefPattern.TAGS.getPath());
    }

    @Override
    @Nonnull
    public RejectedRefState getState() {
        return this.state;
    }

    @Override
    public boolean isTag() {
        return StandardRefType.TAG.equals((Object)this.getType());
    }

    public static class Builder
    extends SimpleMinimalRef.AbstractMinimalRefBuilder<Builder, SimpleRejectedRef> {
        private RejectedRefState state;
        private RefType type;

        public Builder() {
        }

        public Builder(@Nonnull AoRejectedRef ref) {
            this.state = RejectedRefState.fromId(((AoRejectedRef)Preconditions.checkNotNull((Object)ref, (Object)"ref")).getState());
            this.type = SimpleRejectedRef.isTag(ref.getRefId()) ? StandardRefType.TAG : StandardRefType.BRANCH;
            ((Builder)this.displayId(ref.getRefDisplayId())).id(ref.getRefId());
        }

        @Nonnull
        public SimpleRejectedRef build() {
            Preconditions.checkState((this.state != null ? 1 : 0) != 0, (Object)"A state is required for each RejectedRef");
            return new SimpleRejectedRef(this);
        }

        @Nonnull
        public Builder state(@Nonnull RejectedRefState value) {
            this.state = (RejectedRefState)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"state"));
            return this.self();
        }

        @Nonnull
        public Builder type(@Nonnull RefType value) {
            this.type = (RefType)Preconditions.checkNotNull((Object)value, (Object)"refType");
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

