/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.repository.sync.RefSyncStatus;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.atlassian.stash.internal.repository.sync.dao.AoRefSyncConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;

public class SimpleRefSyncStatus
implements RefSyncStatus {
    private final Set<RejectedRef> aheadRefs;
    private final boolean available;
    private final Set<RejectedRef> divergedRefs;
    private final boolean enabled;
    private final Date lastSync;
    private final Set<RejectedRef> orphanedRefs;

    private SimpleRefSyncStatus(Date lastSync, boolean available, boolean enabled, Set<RejectedRef> aheadRefs, Set<RejectedRef> divergedRefs, Set<RejectedRef> orphanedRefs) {
        this.aheadRefs = aheadRefs;
        this.available = available;
        this.divergedRefs = divergedRefs;
        this.enabled = enabled;
        this.lastSync = lastSync;
        this.orphanedRefs = orphanedRefs;
    }

    @Override
    @Nonnull
    public Date getLastSync() {
        return this.lastSync;
    }

    @Override
    @Nonnull
    public Set<RejectedRef> getAheadRefs() {
        return this.aheadRefs;
    }

    @Override
    @Nonnull
    public Set<RejectedRef> getDivergedRefs() {
        return this.divergedRefs;
    }

    @Override
    @Nonnull
    public Set<RejectedRef> getOrphanedRefs() {
        return this.orphanedRefs;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private final ImmutableSet.Builder<RejectedRef> aheadRefs = ImmutableSet.builder();
        private final ImmutableSet.Builder<RejectedRef> divergedRefs = ImmutableSet.builder();
        private final ImmutableSet.Builder<RejectedRef> orphanedRefs = ImmutableSet.builder();
        private boolean available;
        private boolean enabled;
        private Date lastSync;

        public Builder() {
        }

        public Builder(@Nonnull RefSyncStatus status) {
            this();
            this.aheadRefs.addAll(((RefSyncStatus)Preconditions.checkNotNull((Object)status, (Object)"status")).getAheadRefs());
            this.available = status.isAvailable();
            this.divergedRefs.addAll(status.getDivergedRefs());
            this.enabled = status.isEnabled();
            this.lastSync = status.getLastSync();
            this.orphanedRefs.addAll(status.getOrphanedRefs());
        }

        public Builder(@Nonnull AoRefSyncConfig config) {
            this();
            this.enabled = ((AoRefSyncConfig)Preconditions.checkNotNull((Object)config, (Object)"config")).isEnabled();
            this.lastSync = config.getLastSync();
        }

        public SimpleRefSyncStatus build() {
            return new SimpleRefSyncStatus(this.lastSync, this.available, this.enabled, (Set)this.aheadRefs.build(), (Set)this.divergedRefs.build(), (Set)this.orphanedRefs.build());
        }

        public Builder available(boolean value) {
            this.available = value;
            return this;
        }

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder lastSync(@Nonnull Date value) {
            this.lastSync = (Date)Preconditions.checkNotNull((Object)value, (Object)"lastSync");
            return this;
        }

        public Builder rejectedRef(@Nonnull RejectedRef value) {
            this.bucketFor(value).add((Object)value);
            return this;
        }

        private ImmutableSet.Builder<RejectedRef> bucketFor(RejectedRef value) {
            switch (((RejectedRef)Preconditions.checkNotNull((Object)value, (Object)"rejectedRef")).getState()) {
                case AHEAD: {
                    return this.aheadRefs;
                }
                case DIVERGED: {
                    return this.divergedRefs;
                }
                case ORPHANED: {
                    return this.orphanedRefs;
                }
            }
            throw new IllegalArgumentException("RejectedRefState." + (Object)((Object)value.getState()) + " is not supported");
        }
    }
}

