/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.sync;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.sync.RejectedRef;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class RefSyncResult {
    private final Set<RefChange> changedRefs;
    private final Set<RejectedRef> rejectedRefs;
    private final boolean isSynchronized;

    private RefSyncResult(Set<RefChange> changedRefs, Set<RejectedRef> rejectedRefs, boolean aSynchronized) {
        this.changedRefs = changedRefs;
        this.rejectedRefs = rejectedRefs;
        this.isSynchronized = aSynchronized;
    }

    @Nonnull
    public Set<RefChange> getChangedRefs() {
        return this.changedRefs;
    }

    @Nonnull
    public Set<RejectedRef> getRejectedRefs() {
        return this.rejectedRefs;
    }

    public boolean isEmpty() {
        return this.changedRefs.isEmpty() && this.rejectedRefs.isEmpty();
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public static class Builder {
        private final ImmutableSet.Builder<RefChange> changedRefs = ImmutableSet.builder();
        private final ImmutableSet.Builder<RejectedRef> rejectedRefs = ImmutableSet.builder();
        private boolean isSynchronized;

        public RefSyncResult build() {
            return new RefSyncResult((Set)this.changedRefs.build(), (Set)this.rejectedRefs.build(), this.isSynchronized);
        }

        public Builder changedRef(@Nonnull RefChange value) {
            this.changedRefs.add((Object)value);
            return this;
        }

        public Builder changedRefs(@Nonnull Iterable<RefChange> values) {
            this.changedRefs.addAll(values);
            return this;
        }

        public Builder rejectedRef(@Nonnull RejectedRef value) {
            this.rejectedRefs.add((Object)value);
            return this;
        }

        public Builder rejectedRefs(@Nonnull Iterable<RejectedRef> values) {
            this.rejectedRefs.addAll(values);
            return this;
        }

        public Builder isSynchronized() {
            this.isSynchronized = true;
            return this;
        }
    }
}

