/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcherType;
import com.atlassian.bitbucket.rest.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestRefMatcher
extends RestMapEntity {
    private static final String DISPLAY_ID = "displayId";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String ACTIVE = "active";

    protected RestRefMatcher(@Nonnull String id, @Nonnull String displayId, @Nonnull RestRefMatcherType type, boolean active) {
        this.put(ID, id);
        this.put(DISPLAY_ID, displayId);
        this.put(TYPE, (Object)type);
        this.put(ACTIVE, active);
    }

    private RestRefMatcher(Map<String, Object> values) {
        super(values);
    }

    public RestRefMatcher(RefMatcher matcher) {
        this(matcher.getId(), matcher.getDisplayId(), new RestRefMatcherType(matcher.getType()), matcher.isActive());
    }

    @Schema(example="main")
    public String getDisplayId() {
        return this.getStringProperty(DISPLAY_ID);
    }

    @Schema(example="refs/heads/main")
    public String getId() {
        return this.getStringProperty(ID);
    }

    public RestRefMatcherType getType() {
        return RestRefMatcherType.valueOf(this.get(TYPE));
    }

    @Nullable
    public static RestRefMatcher valueOf(@Nullable Object object) {
        if (object instanceof RestRefMatcher) {
            return (RestRefMatcher)((Object)object);
        }
        if (object instanceof Map) {
            return new RestRefMatcher((Map)object);
        }
        return null;
    }
}

