/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SetRestrictionRequest {
    private final List<String> groupGrants;
    private final List<ApplicationUser> userGrants;
    private final Repository repository;
    private final RefMatcher matcher;
    private final RefRestrictionType type;

    private SetRestrictionRequest(Builder builder) {
        this.groupGrants = builder.groupGrants.build();
        this.repository = Objects.requireNonNull(builder.repository, "repositoryId");
        this.matcher = Objects.requireNonNull(builder.matcher, "matcher");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.userGrants = builder.userGrants.build();
    }

    @Nonnull
    public List<String> getGroupGrants() {
        return this.groupGrants;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public int getRepositoryId() {
        return this.repository.getId();
    }

    @Nonnull
    public RefMatcher getMatcher() {
        return this.matcher;
    }

    @Nonnull
    public RefRestrictionType getType() {
        return this.type;
    }

    @Nonnull
    public List<ApplicationUser> getUserGrants() {
        return this.userGrants;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<String> groupGrants = ImmutableList.builder();
        private final ImmutableList.Builder<ApplicationUser> userGrants = ImmutableList.builder();
        private Repository repository;
        private RefMatcher matcher;
        private RefRestrictionType type;

        public Builder(Repository repository, RefMatcher matcher, RefRestrictionType type) {
            this.repository = repository;
            this.matcher = matcher;
            this.type = type;
        }

        @Nonnull
        public SetRestrictionRequest build() {
            return new SetRestrictionRequest(this);
        }

        @Nonnull
        public Builder grantGroups(@Nonnull Iterable<String> value) {
            this.groupGrants.addAll(Objects.requireNonNull(value, "groupGrants"));
            return this;
        }

        @Nonnull
        public Builder grantUsers(@Nonnull Iterable<ApplicationUser> value) {
            this.userGrants.addAll(Objects.requireNonNull(value, "userGrants"));
            return this;
        }
    }
}

