/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.AbstractSearchRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestrictionSearchRequest
extends AbstractSearchRequest {
    private final RefMatcher matcher;
    private final List<RefMatcherType> matcherTypes;

    private RestrictionSearchRequest(Builder builder) {
        super(builder);
        this.matcher = builder.matcher;
        this.matcherTypes = builder.matcherTypeBuilder.build();
    }

    @Nullable
    public RefMatcher getMatcher() {
        return this.matcher;
    }

    @Nonnull
    public List<RefMatcherType> getMatcherTypes() {
        return this.matcherTypes;
    }

    public static class Builder
    extends AbstractSearchRequest.AbstractBuilder<Builder> {
        private final ImmutableList.Builder<RefMatcherType> matcherTypeBuilder = ImmutableList.builder();
        private RefMatcher matcher;

        public Builder(Repository repository) {
            super(repository);
        }

        @Nonnull
        public RestrictionSearchRequest build() {
            return new RestrictionSearchRequest(this);
        }

        @Nonnull
        public Builder matcher(RefMatcher value) {
            this.matcher = value;
            return this.self();
        }

        @Nonnull
        public Builder matcherType(@Nonnull RefMatcherType value) {
            this.matcherTypeBuilder.add((Object)Objects.requireNonNull(value, "matcherType"));
            return this.self();
        }

        @Nonnull
        public Builder matcherTypes(@Nonnull Iterable<RefMatcherType> value) {
            this.matcherTypeBuilder.addAll(Objects.requireNonNull(value, "matcherTypes"));
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

